/*
 * Decompiled with CFR 0.152.
 */
package com.digi.config.ui;

import com.digi.config.core.Device;
import com.digi.config.core.KvpNode;
import com.digi.config.ui.ConfigAction;
import com.digi.config.ui.ConfigView;
import com.digi.config.ui.ConfigViewImpl;
import com.digi.config.ui.CustomPanel;
import com.digi.config.util.ConfigResource;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public abstract class AggregateConfigView
extends ConfigViewImpl {
    JLabel viewTitle;
    JTabbedPane tabbedPane;
    private JPanel viewPanel;
    ArrayList viewList = new ArrayList();
    ConfigView currentView = null;
    ConfigAction saveKvpNodeAction;
    ConfigAction cancelKvpNodeAction;
    ConfigAction refreshAction;
    ConfigAction viewHelpAction;

    public AggregateConfigView() throws Exception {
        super(false);
    }

    public AggregateConfigView(boolean bl) throws Exception {
        super(bl);
    }

    public void addView(ConfigView configView) {
        this.getViewContent();
        this.viewList.add(configView);
        String string = ConfigResource.getUiRbString((String)(configView.getName() + "Title"));
        Icon icon = null;
        String string2 = null;
        this.tabbedPane.addTab(string, icon, configView.getViewContent(), string2);
    }

    public String getName() {
        return "AggregateConfigView";
    }

    public Component getViewContent() {
        if (this.viewPanel == null) {
            this.viewPanel = new CustomPanel();
            this.viewPanel.setLayout(new BorderLayout());
            this.tabbedPane = new JTabbedPane();
            this.tabbedPane.setBackground(new Color(0, 0, 0, 0));
            this.viewPanel.add((Component)this.tabbedPane, "Center");
            ChangeListener changeListener = new ChangeListener(){

                public void stateChanged(ChangeEvent changeEvent) {
                    if (AggregateConfigView.this.device == null) {
                        return;
                    }
                    ConfigView configView = null;
                    int n = AggregateConfigView.this.tabbedPane.getSelectedIndex();
                    if (n >= 0) {
                        configView = (ConfigView)AggregateConfigView.this.viewList.get(n);
                    }
                    if (configView != AggregateConfigView.this.currentView) {
                        if (AggregateConfigView.this.currentView != null) {
                            AggregateConfigView.this.currentView.deactivate();
                        }
                        if (configView != null) {
                            configView.activate();
                        }
                        AggregateConfigView.this.currentView = configView;
                    }
                }
            };
            this.tabbedPane.addChangeListener(changeListener);
        }
        return this.viewPanel;
    }

    public String getHelpResource() {
        String string = null;
        if (this.currentView != null) {
            string = this.currentView.getHelpResource();
        }
        return string;
    }

    public void setDevice(Device device) {
        super.setDevice(device);
        Iterator iterator = this.viewList.iterator();
        while (iterator.hasNext()) {
            ConfigView configView = (ConfigView)iterator.next();
            configView.setDevice(device);
        }
    }

    public void activate() {
        if (this.viewList.size() > 0) {
            if (this.currentView == null) {
                this.currentView = (ConfigView)this.viewList.get(0);
            }
            this.currentView.activate();
        }
        super.activate();
    }

    public void deactivate() {
        if (this.viewList.size() > 0) {
            if (this.currentView == null) {
                this.currentView = (ConfigView)this.viewList.get(0);
            }
            this.currentView.deactivate();
        }
        super.deactivate();
    }

    public boolean isChanged() {
        Iterator iterator = this.viewList.iterator();
        while (iterator.hasNext()) {
            ConfigView configView = (ConfigView)iterator.next();
            if (!configView.isChanged()) continue;
            return true;
        }
        return false;
    }

    public void validateChanges(Collection collection) {
        Iterator iterator = this.viewList.iterator();
        while (iterator.hasNext()) {
            ConfigView configView = (ConfigView)iterator.next();
            configView.validateChanges(collection);
        }
    }

    public void getChanges(KvpNode kvpNode, KvpNode kvpNode2) {
        Iterator iterator = this.viewList.iterator();
        while (iterator.hasNext()) {
            ConfigView configView = (ConfigView)iterator.next();
            configView.getChanges(kvpNode, kvpNode2);
        }
    }

    public void commitChanges() {
        Iterator iterator = this.viewList.iterator();
        while (iterator.hasNext()) {
            ConfigView configView = (ConfigView)iterator.next();
            configView.commitChanges();
        }
    }

    public void cancelChanges() {
        Iterator iterator = this.viewList.iterator();
        while (iterator.hasNext()) {
            ConfigView configView = (ConfigView)iterator.next();
            configView.cancelChanges();
        }
    }
}

