/*
 * Decompiled with CFR 0.152.
 */
package com.digi.config.ui;

import com.digi.config.core.Device;
import com.digi.config.core.DeviceChangeEvent;
import com.digi.config.core.DeviceChangeListener;
import com.digi.config.core.DeviceCommandException;
import com.digi.config.core.DeviceValidationException;
import com.digi.config.core.KvpNode;
import com.digi.config.core.RciCommandError;
import com.digi.config.ui.ConfigAction;
import com.digi.config.ui.ConfigViewImpl;
import com.digi.config.ui.ExampleFileFilter;
import com.digi.config.ui.GridContentPanel;
import com.digi.config.util.Busy;
import com.digi.config.util.ConfigResource;
import com.digi.config.util.SystemLog;
import java.awt.Component;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.Serializable;
import java.util.Collection;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JTextField;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class BackupView
extends ConfigViewImpl {
    KvpNode viewSettingTree = new KvpNode();
    DeviceChangeListener settingChangeListener = new DeviceChangeListener(){

        public void deviceChanged(DeviceChangeEvent deviceChangeEvent) {
            BackupView.this.refreshViewKvpNode();
            BackupView.this.refreshViewControls();
        }
    };
    GridContentPanel content = new GridContentPanel(this.getName(), 2);
    GridContentPanel backupContent;
    GridContentPanel restoreContent;
    JTextField restoreFileName_UIC;
    JButton backup_UIC;
    JButton browse_UIC;
    JButton restore_UIC;

    public BackupView() throws Exception {
        this.content.addBlankLine();
        this.content.addTextLine("BackupRestoreDesc");
        this.content.addBlankLine();
        this.content.addTextLine("BackupDesc");
        this.backupContent = new GridContentPanel(2);
        this.backup_UIC = this.backupContent.addAction(null, (Action)new ConfigAction("Backup1", this, "doBackupAction"), "Backup1Desc");
        this.content.addSubPanel((JComponent)this.backupContent);
        this.content.addBlankLine();
        this.content.addTextLine("RestoreDesc");
        this.restoreContent = new GridContentPanel(2);
        this.restoreFileName_UIC = this.restoreContent.addJTextField("RestoreLabel", null, 300, null, 0, false);
        this.browse_UIC = this.restoreContent.addAction(null, (Action)new ConfigAction("Browse", this, "doBrowseAction"), null, 1, true);
        this.restore_UIC = this.restoreContent.addAction(null, (Action)new ConfigAction("Restore", this, "doRestoreAction"), null);
        this.content.addSubPanel((JComponent)this.restoreContent);
        this.content.addVGlue();
    }

    public void doBackupAction() {
        SystemLog.debug((String)"Backup!");
        JFileChooser jFileChooser = new JFileChooser();
        ExampleFileFilter exampleFileFilter = new ExampleFileFilter();
        exampleFileFilter.addExtension("dcd");
        exampleFileFilter.setDescription(ConfigResource.getUiRbString((String)"BackupDlg.Description"));
        jFileChooser.setFileFilter(exampleFileFilter);
        jFileChooser.setDialogTitle(ConfigResource.getUiRbString((String)"BackupDlg.Title"));
        jFileChooser.setFileSelectionMode(0);
        jFileChooser.setApproveButtonText(ConfigResource.getUiRbString((String)"BackupDlg.Button"));
        jFileChooser.setDialogType(1);
        int n = jFileChooser.showDialog((Component)this.content, ConfigResource.getUiRbString((String)"BackupDlg.Button"));
        if (n == 0) {
            try {
                int n2;
                File file;
                String string = jFileChooser.getSelectedFile().getCanonicalPath();
                if (!string.endsWith(".dcd")) {
                    string = string + ".dcd";
                }
                if ((file = new File(string)).exists() && (n2 = JOptionPane.showConfirmDialog((Component)this.content, new JLabel("File '" + string + "' already exists. Are you sure you want to overwrite it?"), "Confirm overwrite", 0)) == 1) {
                    SystemLog.log((String)"Op1Cancelled", (Serializable[])new Serializable[]{"Backup"});
                    return;
                }
                file.createNewFile();
                FileOutputStream fileOutputStream = new FileOutputStream(file);
                DataOutputStream dataOutputStream = new DataOutputStream(fileOutputStream);
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append("<rci_backup version=\"1.1\">\n");
                KvpNode kvpNode = this.device.getSettingTree();
                KvpNode kvpNode2 = kvpNode.getChild("simple_password");
                if (kvpNode2 != null) {
                    kvpNode2.removeChild("password");
                    kvpNode2.removeChild("public_comm");
                    kvpNode2.removeChild("private_comm");
                }
                kvpNode.toXml(stringBuffer, "", false);
                stringBuffer.append("</rci_backup>\n");
                dataOutputStream.writeBytes(stringBuffer.toString());
                dataOutputStream.close();
                fileOutputStream.close();
                SystemLog.log((String)"Op1Succ", (Serializable[])new Serializable[]{"Backup"});
            }
            catch (Exception exception) {
                SystemLog.log((String)"Op1Fail", (Serializable[])new Serializable[]{"Backup"}, (Throwable)exception);
            }
        }
    }

    public void doBrowseAction() {
        SystemLog.debug((String)"Browse!");
        JFileChooser jFileChooser = new JFileChooser();
        ExampleFileFilter exampleFileFilter = new ExampleFileFilter();
        exampleFileFilter.addExtension("dcd");
        exampleFileFilter.setDescription(ConfigResource.getUiRbString((String)"RestoreDlg.Description"));
        jFileChooser.setFileFilter(exampleFileFilter);
        jFileChooser.setDialogTitle(ConfigResource.getUiRbString((String)"RestoreDlg.Description"));
        jFileChooser.setDialogType(0);
        jFileChooser.setFileSelectionMode(0);
        int n = jFileChooser.showOpenDialog((Component)this.content);
        if (n == 0) {
            try {
                this.restoreFileName_UIC.setText(jFileChooser.getSelectedFile().getCanonicalPath());
            }
            catch (Exception exception) {
                SystemLog.log((String)"Op1Fail", (Serializable[])new Serializable[]{"Browse"}, (Throwable)exception);
            }
        }
    }

    public void doRestoreAction() {
        SystemLog.debug((String)"Restore!");
        String string = this.restoreFileName_UIC.getText();
        File file = new File(string);
        if (!file.exists() && !string.endsWith(".dcd")) {
            string = string + ".dcd";
            file = new File(string);
        }
        Busy.begin((String)ConfigResource.getUiRbString((String)"SaveChangesStatus"));
        if (file.exists()) {
            try {
                FileInputStream fileInputStream = new FileInputStream(file);
                DataInputStream dataInputStream = new DataInputStream(fileInputStream);
                DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
                DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
                Document document = documentBuilder.parse(dataInputStream);
                Node node = document.getFirstChild();
                String string2 = node.getNodeName();
                if (!string2.equals("rci_backup")) {
                    SystemLog.log((String)"RestoreFileInvalidError", (Serializable[])new Serializable[]{string});
                    return;
                }
                SystemLog.debug((String)"Parsed rci_backup file. Extracting Settings");
                KvpNode kvpNode = new KvpNode(node);
                String string3 = kvpNode.getAttribute("version");
                if (string3 == null) {
                    string3 = "1.0";
                }
                this.device.restoreBackupSettingTree(kvpNode, string3);
                SystemLog.log((String)"Op1Succ", (Serializable[])new Serializable[]{ConfigResource.getUiRbString((String)"RestoreMenu")});
            }
            catch (DeviceCommandException deviceCommandException) {
                SystemLog.log((String)"Op1Fail", (Serializable[])new Serializable[]{ConfigResource.getUiRbString((String)"RestoreMenu")}, (Throwable)deviceCommandException);
            }
            catch (DeviceValidationException deviceValidationException) {
                SystemLog.debug((String)"Invalid fields detected while saving to device", (Throwable)deviceValidationException);
                KvpNode kvpNode = deviceValidationException.getCluster();
                Collection collection = kvpNode.getErrors();
                StringBuffer stringBuffer = new StringBuffer();
                Object object = collection.iterator();
                while (object.hasNext()) {
                    RciCommandError rciCommandError = (RciCommandError)object.next();
                    stringBuffer.append(rciCommandError.toString() + "\n");
                }
                object = new StringBuffer();
                ((StringBuffer)object).append(ConfigResource.getUiRbString((String)"ValidationErrorDesc") + "\n");
                ((StringBuffer)object).append(stringBuffer);
                JOptionPane.showMessageDialog((Component)this.content, ((StringBuffer)object).toString(), ConfigResource.getUiRbString((String)"ValidationErrorTitle"), 0);
                SystemLog.log((String)"ValidationError", (Serializable[])new Serializable[]{stringBuffer.toString()});
            }
            catch (Exception exception) {
                SystemLog.log((String)"Op1Fail", (Serializable[])new Serializable[]{ConfigResource.getUiRbString((String)"RestoreMenu")}, (Throwable)exception);
            }
        } else {
            SystemLog.log((String)"RestoreFileInvalidError", (Serializable[])new Serializable[]{string});
        }
        Busy.end();
    }

    public String getName() {
        return "BackupView";
    }

    public Component getViewContent() {
        return this.content;
    }

    public Component getViewButtons() {
        return null;
    }

    public void setDevice(Device device) {
        super.setDevice(device);
        this.refreshViewKvpNode();
        this.refreshViewControls();
        device.addSettingChangeListener(this.settingChangeListener);
    }

    private void refreshViewKvpNode() {
        this.viewSettingTree.clear();
    }

    private void refreshViewControls() {
    }

    public void activate() {
        SystemLog.debug((String)"Activating BackupView");
    }

    public void deactivate() {
        SystemLog.debug((String)"Deactivating BackupView");
    }

    public boolean isChanged() {
        return false;
    }

    public void getChanges(KvpNode kvpNode, KvpNode kvpNode2) {
    }

    public void commitChanges() {
    }

    public void cancelChanges() {
    }
}

