/*
 * Decompiled with CFR 0.152.
 */
package com.digi.config.ui;

import com.digi.config.core.Device;
import com.digi.config.core.DeviceCommandException;
import com.digi.config.ui.AlarmGpioView;
import com.digi.config.ui.BackupView;
import com.digi.config.ui.ConfigAction;
import com.digi.config.ui.ConfigView;
import com.digi.config.ui.CustomPanel;
import com.digi.config.ui.GlobalSettingView;
import com.digi.config.ui.GpioView;
import com.digi.config.ui.HomeView;
import com.digi.config.ui.MessageArea;
import com.digi.config.ui.NetworkView;
import com.digi.config.ui.RebootView;
import com.digi.config.ui.RestoreFactoryDefaultsView;
import com.digi.config.ui.SecureAccessIcon;
import com.digi.config.ui.SecurityView;
import com.digi.config.ui.SerialView;
import com.digi.config.ui.SplashScreenPanel;
import com.digi.config.ui.StatusPanel;
import com.digi.config.ui.SystemView;
import com.digi.config.util.Busy;
import com.digi.config.util.ConfigResource;
import com.digi.config.util.ConfigSettings;
import com.digi.config.util.HelpDisplay;
import com.digi.config.util.StatusDisplay;
import com.digi.config.util.SystemLog;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.StringWriter;
import java.net.URL;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.UIManager;
import javax.swing.border.EtchedBorder;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.FontUIResource;
import javax.swing.plaf.metal.DefaultMetalTheme;
import javax.swing.plaf.metal.MetalLookAndFeel;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ConfigAppPanel
extends CustomPanel
implements StatusDisplay {
    Device device;
    JPanel titleBar = null;
    JMenuBar menuBar = null;
    JToolBar toolBar = null;
    JPanel actionPanel = null;
    JPanel navigationPanel = null;
    JPanel contentPanel = null;
    StatusPanel statusPanel = null;
    JPanel urlPanel = null;
    private MessageArea messageArea;
    SecureAccessIcon secureAccessIcon = null;
    boolean showMenuBar = false;
    boolean showToolBar = false;
    boolean showNavigationPanel = true;
    boolean artificialFrame = false;
    private static final int PREFERRED_WIDTH = 720;
    private static final int PREFERRED_HEIGHT = 640;
    Action homeAction;
    Action configAllAction;
    Action networkAction;
    Action serialAction;
    Action gpioAction;
    Action securityAction;
    Action systemAction;
    Action alarmAction;
    Action rebootAction;
    Action backupAction;
    Action updateFirmwareAction;
    Action factoryAction;
    Action configHelpAction;
    Action viewHelpAction;
    ConfigView homeView;
    ConfigView configAllView;
    ConfigView networkView;
    ConfigView serialView;
    ConfigView gpioView;
    ConfigView securityView;
    ConfigView systemView;
    ConfigView alarmView;
    ConfigView backupView;
    ConfigView rebootView;
    ConfigView factoryView;
    ConfigView currentView;

    public ConfigAppPanel() throws Exception {
        this(true);
    }

    public ConfigAppPanel(boolean bl) throws Exception {
        super("App");
        this.artificialFrame = bl;
        ConfigTheme configTheme = new ConfigTheme();
        MetalLookAndFeel.setCurrentTheme(configTheme);
        UIManager.setLookAndFeel(UIManager.getCrossPlatformLookAndFeelClassName());
        Color color = ConfigSettings.getColor((String)"WindowSettings", (String)"TabbedPaneBackgroundColor");
        if (color != null) {
            UIManager.put("TabbedPane.selected", color);
        }
        if (this.backgroundImage == null && (this.backgroundColor == null || this.backgroundColor.getAlpha() == 0)) {
            this.setBackground(ConfigSettings.getColor((String)"WindowSettings", (String)"BackgroundColor"));
        }
        this.setBorder(new EtchedBorder());
        this.device = new Device();
        SplashScreenPanel.currentScreen().updateProgress();
        try {
            this.device.refreshSettingTree();
            SplashScreenPanel.currentScreen().updateProgress();
        }
        catch (DeviceCommandException deviceCommandException) {
            SystemLog.log((String)"DeviceNotAvailable", (Serializable[])new Serializable[]{this.device.getUrlName()}, (Throwable)deviceCommandException);
        }
        this.initializeActions();
        this.setLayout(new BorderLayout());
        this.add(this.getActionPanel(), "North");
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        jPanel.setOpaque(false);
        jPanel.add((Component)this.getNavigationPanel(), "West");
        jPanel.add((Component)this.getContentPanel(), "Center");
        JSplitPane jSplitPane = new JSplitPane(0, true, jPanel, (Component)((Object)this.getMessageAreaPanel()));
        jSplitPane.setOpaque(false);
        jSplitPane.setDividerLocation(-1);
        jSplitPane.setResizeWeight(1.0);
        jSplitPane.setDividerSize(1);
        this.add(jSplitPane, "Center");
        this.add(this.getStatusPanel(), "South");
        if (!ConfigSettings.getBoolean((String)"General", (String)"AppletMode") || ConfigSettings.getBoolean((String)"DebugSettings", (String)"GeneralDebug")) {
            this.statusPanel.addTrayComponent(this.getUrlPanel());
        }
        this.secureAccessIcon = new SecureAccessIcon(this.device.getUrlName());
        this.statusPanel.addTrayComponent(this.secureAccessIcon);
        boolean bl2 = ConfigSettings.getBoolean((String)"PropertiesSettings", (String)"UseMenus");
        this.getMenuBar().setVisible(bl2);
        this.getToolBar().setVisible(bl2);
        this.getNavigationPanel().setVisible(!bl2);
        Busy.registerGUIComponent((StatusDisplay)this);
        this.doHomeAction();
        SplashScreenPanel.currentScreen().updateProgress();
    }

    public void initializeActions() throws Exception {
        SplashScreenPanel.currentScreen().updateProgress();
        this.homeAction = new ConfigAction("Home", (Object)this, "doHomeAction");
        this.configAllAction = new ConfigAction("ConfigAll", (Object)this, "doConfigAllAction");
        this.networkAction = new ConfigAction("Network", (Object)this, "doNetworkAction");
        this.serialAction = new ConfigAction("Serial", (Object)this, "doSerialAction");
        this.gpioAction = new ConfigAction("Gpio", (Object)this, "doGpioAction");
        this.securityAction = new ConfigAction("Security", (Object)this, "doSecurityAction");
        this.systemAction = new ConfigAction("System", (Object)this, "doSystemAction");
        this.alarmAction = new ConfigAction("Alarm", (Object)this, "doAlarmAction");
        this.backupAction = new ConfigAction("Backup", (Object)this, "doBackupAction");
        this.rebootAction = new ConfigAction("Reboot", (Object)this, "doRebootAction");
        this.updateFirmwareAction = new ConfigAction("UpdateFirmware", (Object)this, "doUpdateFirmwareAction");
        this.factoryAction = new ConfigAction("RestoreFactoryDefaults", (Object)this, "doFactoryAction");
        this.configHelpAction = new ConfigAction("ConfigHelp", (Object)this, "doConfigHelpAction");
        this.viewHelpAction = new ConfigAction("ViewHelp", (Object)this, "doViewHelpAction");
        SplashScreenPanel.currentScreen().updateProgress();
    }

    public void initializeViews() throws Exception {
        SplashScreenPanel.currentScreen().updateProgress();
        this.homeView = new HomeView();
        this.homeView.setDevice(this.device);
        SplashScreenPanel.currentScreen().updateProgress();
        this.configAllView = new GlobalSettingView();
        this.configAllView.setDevice(this.device);
        SplashScreenPanel.currentScreen().updateProgress();
        this.networkView = new NetworkView();
        this.networkView.setDevice(this.device);
        SplashScreenPanel.currentScreen().updateProgress();
        this.serialView = new SerialView();
        this.serialView.setDevice(this.device);
        SplashScreenPanel.currentScreen().updateProgress();
        this.gpioView = new GpioView();
        this.gpioView.setDevice(this.device);
        SplashScreenPanel.currentScreen().updateProgress();
        this.securityView = new SecurityView();
        this.securityView.setDevice(this.device);
        SplashScreenPanel.currentScreen().updateProgress();
        this.systemView = new SystemView();
        this.systemView.setDevice(this.device);
        SplashScreenPanel.currentScreen().updateProgress();
        this.alarmView = new AlarmGpioView();
        this.alarmView.setDevice(this.device);
        SplashScreenPanel.currentScreen().updateProgress();
        this.backupView = new BackupView();
        this.backupView.setDevice(this.device);
        SplashScreenPanel.currentScreen().updateProgress();
        this.rebootView = new RebootView();
        this.rebootView.setDevice(this.device);
        SplashScreenPanel.currentScreen().updateProgress();
        this.factoryView = new RestoreFactoryDefaultsView();
        this.factoryView.setDevice(this.device);
        SplashScreenPanel.currentScreen().updateProgress();
    }

    public JPanel getActionPanel() {
        if (this.actionPanel == null) {
            this.actionPanel = new JPanel();
            this.actionPanel.setLayout(new BoxLayout(this.actionPanel, 1));
            if (this.artificialFrame) {
                this.actionPanel.add(this.getTitleBar());
            }
            this.actionPanel.add(this.getMenuBar());
            this.actionPanel.add(this.getToolBar());
            SplashScreenPanel.currentScreen().updateProgress();
        }
        return this.actionPanel;
    }

    public JPanel getNavigationPanel() {
        if (this.navigationPanel == null) {
            int n;
            SplashScreenPanel.currentScreen().updateProgress();
            this.navigationPanel = new CustomPanel("Navigation");
            this.navigationPanel.setLayout(new BoxLayout(this.navigationPanel, 1));
            this.navigationPanel.setBorder(new EtchedBorder());
            JMenuBar jMenuBar = this.getMenuBar();
            Color color = ConfigSettings.getColor((String)"WindowSettings", (String)"MenuColor");
            if (color == null) {
                color = Color.BLUE;
            }
            for (n = 0; n < jMenuBar.getMenuCount(); ++n) {
                JComponent jComponent;
                JMenu jMenu = jMenuBar.getMenu(n);
                if (jMenu == null) continue;
                if (jMenu.getAction() == null) {
                    jComponent = new JLabel(jMenu.getText());
                    jComponent.setBorder(BorderFactory.createEmptyBorder(2, 10, 2, 10));
                } else {
                    jComponent = new JButton(jMenu.getAction());
                    ((JButton)jComponent).setContentAreaFilled(false);
                    ((JButton)jComponent).setBorderPainted(false);
                    ((JButton)jComponent).setForeground(color);
                    ((JButton)jComponent).setIcon(null);
                    ((JButton)jComponent).setBorder(BorderFactory.createEmptyBorder(2, 10, 2, 10));
                    ((JButton)jComponent).setCursor(Cursor.getPredefinedCursor(12));
                }
                this.navigationPanel.add(jComponent);
                for (int i = 0; i < jMenu.getMenuComponentCount(); ++i) {
                    Component component = jMenu.getMenuComponent(i);
                    if (component == null || !(component instanceof JMenuItem)) continue;
                    JMenuItem jMenuItem = (JMenuItem)component;
                    if (jMenuItem.getAction() == null) {
                        jComponent = new JLabel(jMenuItem.getText());
                        ((JLabel)jComponent).setBorder(BorderFactory.createEmptyBorder(2, 20, 2, 10));
                    } else {
                        jComponent = new JButton(jMenuItem.getAction());
                        ((JButton)jComponent).setContentAreaFilled(false);
                        ((JButton)jComponent).setBorderPainted(false);
                        ((JButton)jComponent).setForeground(color);
                        ((JButton)jComponent).setIcon(null);
                        ((JButton)jComponent).setBorder(BorderFactory.createEmptyBorder(2, 20, 2, 10));
                        ((JButton)jComponent).setCursor(Cursor.getPredefinedCursor(12));
                    }
                    this.navigationPanel.add(jComponent);
                    if (!(jMenuItem instanceof JMenu)) continue;
                }
            }
            n = ConfigSettings.getInteger((String)"WindowSettings", (String)"NavigationAreaWidth");
            int n2 = ConfigSettings.getInteger((String)"WindowSettings", (String)"NavigationAreaHeight");
            this.navigationPanel.setSize(n, n2);
            SplashScreenPanel.currentScreen().updateProgress();
        }
        return this.navigationPanel;
    }

    public JPanel getTitleBar() {
        if (this.titleBar == null) {
            this.titleBar = new JPanel();
            this.titleBar.setBackground(new Color(0, 0, 139));
            JLabel jLabel = new JLabel(ConfigResource.getUiRbString((String)"AppTitle"));
            jLabel.setForeground(Color.WHITE);
            this.titleBar.add(jLabel);
            this.titleBar.setAlignmentX(0.0f);
            SplashScreenPanel.currentScreen().updateProgress();
        }
        return this.titleBar;
    }

    public JMenuBar getMenuBar() {
        if (this.menuBar == null) {
            this.menuBar = new JMenuBar();
            this.menuBar.add(new JMenu(this.homeAction));
            JMenu jMenu = this.menuBar.add(new JMenu("Configuration"));
            jMenu.add(new JMenuItem(this.networkAction));
            jMenu.add(new JMenuItem(this.serialAction));
            jMenu.add(new JMenuItem(this.gpioAction));
            jMenu.add(new JMenuItem(this.securityAction));
            if (ConfigSettings.getBoolean((String)"DebugSettings", (String)"GeneralDebug")) {
                jMenu.add(new JMenuItem(this.configAllAction));
            }
            jMenu = this.menuBar.add(new JMenu("Management"));
            jMenu.add(new JMenuItem(this.alarmAction));
            jMenu = this.menuBar.add(new JMenu("Administration"));
            jMenu.add(new JMenuItem(this.backupAction));
            jMenu.add(new JMenuItem(this.factoryAction));
            jMenu.add(new JMenuItem(this.systemAction));
            jMenu.add(new JMenuItem(this.rebootAction));
            this.menuBar.add(Box.createHorizontalGlue());
            this.menuBar.setAlignmentX(0.0f);
            SplashScreenPanel.currentScreen().updateProgress();
        }
        return this.menuBar;
    }

    public JToolBar getToolBar() {
        if (this.toolBar == null) {
            this.toolBar = new JToolBar();
            this.toolBar.add(this.configAllAction);
            this.toolBar.add(this.viewHelpAction);
            this.toolBar.add(Box.createHorizontalGlue());
            this.toolBar.setAlignmentX(0.0f);
            SplashScreenPanel.currentScreen().updateProgress();
        }
        return this.toolBar;
    }

    public JPanel getContentPanel() {
        if (this.contentPanel == null) {
            this.contentPanel = new CustomPanel("Content");
            this.contentPanel.setLayout(new BorderLayout());
            this.contentPanel.setBorder(BorderFactory.createEtchedBorder());
            SplashScreenPanel.currentScreen().updateProgress();
        }
        return this.contentPanel;
    }

    public StatusPanel getStatusPanel() throws Exception {
        this.statusPanel = StatusPanel.getInstance();
        SplashScreenPanel.currentScreen().updateProgress();
        return this.statusPanel;
    }

    public JPanel getUrlPanel() {
        if (this.urlPanel == null) {
            this.urlPanel = new JPanel(new BorderLayout());
            JLabel jLabel = new JLabel("RCI Server URL: ");
            this.urlPanel.add((Component)jLabel, "West");
            JTextField jTextField = new JTextField();
            jTextField.setMaximumSize(new Dimension(250, 20));
            jTextField.setPreferredSize(new Dimension(250, 20));
            jTextField.setText(this.device.getUrlName());
            jTextField.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    try {
                        String string = ((JTextField)actionEvent.getSource()).getText();
                        ConfigAppPanel.this.device.setUrlName(string);
                        ConfigAppPanel.this.secureAccessIcon.setSecure(string);
                        ConfigAppPanel.this.device.refreshSettingTree();
                        ConfigAppPanel.this.device.refreshStateTree();
                        ConfigAppPanel.this.doHomeAction();
                    }
                    catch (DeviceCommandException deviceCommandException) {
                        SystemLog.log((String)"DeviceNotAvailable", (Serializable[])new Serializable[]{ConfigAppPanel.this.device.getUrlName()}, (Throwable)deviceCommandException);
                    }
                    catch (Exception exception) {
                        SystemLog.log((String)"Op1Fail", (Serializable[])new Serializable[]{"SetDeviceIP"}, (Throwable)exception);
                    }
                }
            });
            this.urlPanel.add((Component)jTextField, "Center");
            SplashScreenPanel.currentScreen().updateProgress();
        }
        return this.urlPanel;
    }

    private MessageArea getMessageAreaPanel() throws Exception {
        if (this.messageArea == null) {
            this.messageArea = new MessageArea();
            this.messageArea.doRefreshLogAction();
            this.messageArea.doSetMinimumSeverityInformationFilterAction();
            SplashScreenPanel.currentScreen().updateProgress();
        }
        return this.messageArea;
    }

    public void switchToView(ConfigView configView) {
        if (configView == null) {
            return;
        }
        if (this.currentView != null) {
            this.contentPanel.removeAll();
            this.currentView.deactivate();
        }
        configView.activate();
        if (configView.getViewHeading() != null) {
            this.contentPanel.add(configView.getViewHeading(), "North");
        }
        if (configView.getViewContent() != null) {
            JScrollPane jScrollPane = new JScrollPane(configView.getViewContent());
            jScrollPane.setOpaque(false);
            jScrollPane.getViewport().setOpaque(false);
            this.contentPanel.add((Component)jScrollPane, "Center");
        }
        if (configView.getViewButtons() != null) {
            this.contentPanel.add(configView.getViewButtons(), "South");
        }
        this.revalidate();
        this.repaint();
        this.currentView = configView;
    }

    public void updateStatus(boolean bl, String string) {
        this.statusPanel.setStatusText(string);
        if (bl) {
            this.setCursor(Cursor.getPredefinedCursor(3));
        } else {
            this.setCursor(Cursor.getPredefinedCursor(0));
        }
    }

    public String getStatusText() {
        return this.statusPanel.getStatusText();
    }

    public void doHomeAction() throws Exception {
        if (this.homeView == null) {
            SplashScreenPanel.currentScreen().updateProgress();
            this.homeView = new HomeView();
            this.homeView.setDevice(this.device);
        }
        this.switchToView(this.homeView);
    }

    public void doConfigAllAction() throws Exception {
        if (this.configAllView == null) {
            this.configAllView = new GlobalSettingView();
            this.configAllView.setDevice(this.device);
        }
        this.switchToView(this.configAllView);
    }

    public void doNetworkAction() throws Exception {
        if (this.networkView == null) {
            this.networkView = new NetworkView();
            this.networkView.setDevice(this.device);
        }
        this.switchToView(this.networkView);
    }

    public void doSerialAction() throws Exception {
        if (this.serialView == null) {
            this.serialView = new SerialView();
            this.serialView.setDevice(this.device);
        }
        this.switchToView(this.serialView);
    }

    public void doGpioAction() throws Exception {
        if (this.gpioView == null) {
            this.gpioView = new GpioView();
            this.gpioView.setDevice(this.device);
        }
        this.switchToView(this.gpioView);
    }

    public void doSecurityAction() throws Exception {
        if (this.securityView == null) {
            this.securityView = new SecurityView();
            this.securityView.setDevice(this.device);
        }
        this.switchToView(this.securityView);
    }

    public void doSystemAction() throws Exception {
        if (this.systemView == null) {
            this.systemView = new SystemView();
            this.systemView.setDevice(this.device);
        }
        this.switchToView(this.systemView);
    }

    public void doAlarmAction() throws Exception {
        if (this.alarmView == null) {
            this.alarmView = new AlarmGpioView();
            this.alarmView.setDevice(this.device);
        }
        this.switchToView(this.alarmView);
    }

    public void doBackupAction() throws Exception {
        if (this.backupView == null) {
            this.backupView = new BackupView();
            this.backupView.setDevice(this.device);
        }
        this.switchToView(this.backupView);
    }

    public void doRebootAction() throws Exception {
        if (this.rebootView == null) {
            this.rebootView = new RebootView();
            this.rebootView.setDevice(this.device);
        }
        this.switchToView(this.rebootView);
    }

    public void doUpdateFirmwareAction() throws Exception {
        String string = this.device.getUrlName();
        String string2 = "";
        try {
            URL uRL = new URL(string);
            string2 = uRL.getProtocol() + "://" + uRL.getHost() + "/admin/upgrade_firmware.htm";
            HelpDisplay.showHelp((String)string2);
        }
        catch (Exception exception) {
            SystemLog.log((String)"DeviceNotAvailable", (Serializable[])new Serializable[]{string2}, (Throwable)exception);
        }
    }

    public void doFactoryAction() throws Exception {
        if (this.factoryView == null) {
            this.factoryView = new RestoreFactoryDefaultsView();
            this.factoryView.setDevice(this.device);
        }
        this.switchToView(this.factoryView);
    }

    public void doConfigHelpAction() throws Exception {
        HelpDisplay.showHelp((String)"UserGuide");
    }

    public void doViewHelpAction() throws Exception {
        String string = this.currentView.getHelpResource();
        if (string == null) {
            SystemLog.log((String)"NoHelpAvailable");
        } else {
            SystemLog.debug((String)("Launching view help . Help key = " + string));
            HelpDisplay.showHelp((String)string);
        }
    }

    private void dumpNode(Node node, StringBuffer stringBuffer, String string) {
        stringBuffer.append(string + "Node Name = " + node.getNodeName() + ", Type = " + node.getNodeType() + ", Value = '" + node.getNodeValue() + "'\n");
    }

    private void dumpTree(Node node, StringBuffer stringBuffer, String string) {
        this.dumpNode(node, stringBuffer, string);
        NodeList nodeList = node.getChildNodes();
        String string2 = string + "  ";
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node2 = nodeList.item(i);
            this.dumpTree(node2, stringBuffer, string2);
        }
    }

    private void dump(Throwable throwable, StringBuffer stringBuffer) {
        stringBuffer.append(throwable.getMessage());
        StringWriter stringWriter = new StringWriter();
        throwable.printStackTrace(new PrintWriter(stringWriter));
        stringBuffer.append(stringWriter.getBuffer().toString());
    }

    private class ConfigTheme
    extends DefaultMetalTheme {
        Color control = ConfigSettings.getColor((String)"WindowSettings", (String)"ControlColor");
        Color black = ConfigSettings.getColor((String)"WindowSettings", (String)"Black", (String)"WindowSettings", (String)"TextColor");
        Color white = ConfigSettings.getColor((String)"WindowSettings", (String)"White", (String)"WindowSettings", (String)"BackgroundColor");
        Color primary1 = ConfigSettings.getColor((String)"WindowSettings", (String)"Primary1");
        Color primary2 = ConfigSettings.getColor((String)"WindowSettings", (String)"Primary2");
        Color primary3 = ConfigSettings.getColor((String)"WindowSettings", (String)"Primary3");
        Color secondary1 = ConfigSettings.getColor((String)"WindowSettings", (String)"Secondary1");
        Color secondary2 = ConfigSettings.getColor((String)"WindowSettings", (String)"Secondary2", (String)"WindowSettings", (String)"DisabledColor");
        Color secondary3 = ConfigSettings.getColor((String)"WindowSettings", (String)"Secondary3", (String)"WindowSettings", (String)"ControlColor");
        Font windowTitleFont = ConfigSettings.getFont((String)"WindowSettings", (String)"WindowTitleFont", (String)"WindowSettings", (String)"TextFont");
        Font systemTextFont = ConfigSettings.getFont((String)"WindowSettings", (String)"SystemTextFont", (String)"WindowSettings", (String)"TextFont");
        Font userTextFont = ConfigSettings.getFont((String)"WindowSettings", (String)"UserTextFont", (String)"WindowSettings", (String)"TextFont");
        Font controlTextFont = ConfigSettings.getFont((String)"WindowSettings", (String)"ControlTextFont", (String)"WindowSettings", (String)"TextFont");
        Font menuTextFont = ConfigSettings.getFont((String)"WindowSettings", (String)"MenuTextFont", (String)"WindowSettings", (String)"TextFont");
        Font subTextFont = ConfigSettings.getFont((String)"WindowSettings", (String)"SubTextFont", (String)"WindowSettings", (String)"TextFont");

        private ConfigTheme() {
        }

        public ColorUIResource getControl() {
            return this.control != null ? new ColorUIResource(this.control) : super.getControl();
        }

        protected ColorUIResource getBlack() {
            return this.black != null ? new ColorUIResource(this.black) : super.getBlack();
        }

        protected ColorUIResource getWhite() {
            return this.white != null ? new ColorUIResource(this.white) : super.getWhite();
        }

        protected ColorUIResource getPrimary1() {
            return this.primary1 != null ? new ColorUIResource(this.primary1) : super.getPrimary1();
        }

        protected ColorUIResource getPrimary2() {
            return this.primary2 != null ? new ColorUIResource(this.primary2) : super.getPrimary2();
        }

        protected ColorUIResource getPrimary3() {
            return this.primary3 != null ? new ColorUIResource(this.primary3) : super.getPrimary3();
        }

        protected ColorUIResource getSecondary1() {
            return this.secondary1 != null ? new ColorUIResource(this.secondary1) : super.getSecondary1();
        }

        protected ColorUIResource getSecondary2() {
            return this.secondary2 != null ? new ColorUIResource(this.secondary2) : super.getSecondary2();
        }

        protected ColorUIResource getSecondary3() {
            return this.secondary3 != null ? new ColorUIResource(this.secondary3) : super.getSecondary3();
        }

        public FontUIResource getWindowTitleFont() {
            return this.windowTitleFont != null ? new FontUIResource(this.windowTitleFont) : super.getWindowTitleFont();
        }

        public FontUIResource getSystemTextFont() {
            return this.systemTextFont != null ? new FontUIResource(this.systemTextFont) : super.getSystemTextFont();
        }

        public FontUIResource getUserTextFont() {
            return this.userTextFont != null ? new FontUIResource(this.userTextFont) : super.getUserTextFont();
        }

        public FontUIResource getControlTextFont() {
            return this.controlTextFont != null ? new FontUIResource(this.controlTextFont) : super.getControlTextFont();
        }

        public FontUIResource getMenuTextFont() {
            return this.menuTextFont != null ? new FontUIResource(this.menuTextFont) : super.getMenuTextFont();
        }

        public FontUIResource getSubTextFont() {
            return this.subTextFont != null ? new FontUIResource(this.subTextFont) : super.getSubTextFont();
        }
    }
}

