/*
 * Decompiled with CFR 0.152.
 */
package com.digi.config.ui;

import com.digi.config.core.Device;
import com.digi.config.core.DeviceCommandException;
import com.digi.config.core.DeviceValidationException;
import com.digi.config.core.KvpNode;
import com.digi.config.core.RciCommandError;
import com.digi.config.core.ValidationError;
import com.digi.config.ui.ConfigAction;
import com.digi.config.ui.ConfigView;
import com.digi.config.ui.CustomPanel;
import com.digi.config.util.Busy;
import com.digi.config.util.ConfigResource;
import com.digi.config.util.HelpDisplay;
import com.digi.config.util.SystemLog;
import java.awt.Color;
import java.awt.Component;
import java.awt.Toolkit;
import java.io.Serializable;
import java.util.Collection;
import java.util.Vector;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.PlainDocument;

public abstract class ConfigViewImpl
implements ConfigView {
    Device device;
    protected boolean active;
    protected boolean editView;
    protected boolean includeSettingsFields;
    protected boolean includeStateFields;
    JLabel heading;
    private JPanel buttonPanel;
    ConfigAction saveChangesAction;
    ConfigAction cancelChangesAction;
    ConfigAction refreshAction;
    ConfigAction viewHelpAction;

    public ConfigViewImpl() throws Exception {
        this(false);
    }

    public ConfigViewImpl(boolean bl) throws Exception {
        this.initializeActions();
        this.active = false;
        this.editView = bl;
        this.includeSettingsFields = true;
        this.includeStateFields = false;
    }

    public void setIncludeSettingsFields(boolean bl) {
        this.includeSettingsFields = bl;
    }

    public void setIncludeStateFields(boolean bl) {
        this.includeStateFields = bl;
    }

    public Component getViewHeading() {
        if (this.heading == null) {
            this.heading = new JLabel(ConfigResource.getUiRbString((String)(this.getName() + "Title")));
            this.heading.setBackground(new Color(0, 0, 139));
            this.heading.setForeground(Color.WHITE);
            this.heading.setOpaque(true);
        }
        return this.heading;
    }

    public Component getViewButtons() {
        if (this.buttonPanel == null) {
            this.buttonPanel = new CustomPanel();
            this.buttonPanel.setLayout(new BoxLayout(this.buttonPanel, 0));
            if (this.editView) {
                this.buttonPanel.add(Box.createHorizontalGlue());
                this.buttonPanel.add(new JButton(this.saveChangesAction));
                this.buttonPanel.add(Box.createHorizontalGlue());
                this.buttonPanel.add(new JButton(this.cancelChangesAction));
            }
            this.buttonPanel.add(Box.createHorizontalGlue());
            this.buttonPanel.add(new JButton(this.refreshAction));
            this.buttonPanel.add(Box.createHorizontalGlue());
        }
        return this.buttonPanel;
    }

    public void setDevice(Device device) {
        this.device = device;
    }

    public void activate() {
        this.active = true;
    }

    public void deactivate() {
        this.active = false;
    }

    public String getHelpResource() {
        return this.getName() + "Help";
    }

    public void validateChanges(Collection collection) {
    }

    protected void initializeActions() throws Exception {
        this.saveChangesAction = new ConfigAction("SaveChanges", this, "doSaveChangesAction");
        this.cancelChangesAction = new ConfigAction("CancelChanges", this, "doCancelChangesAction");
        this.refreshAction = new ConfigAction("Refresh", this, "doRefreshAction");
        this.viewHelpAction = new ConfigAction("ViewHelp", this, "doViewHelpAction");
    }

    public void doSaveChangesAction() {
        Busy.begin((String)ConfigResource.getUiRbString((String)"SaveChangesStatus"));
        SystemLog.debug((String)"ConfigViewImpl.doSaveChangesAction invoked");
        if (this.isChanged()) {
            Vector vector = new Vector();
            this.validateChanges(vector);
            if (vector.size() > 0) {
                StringBuffer stringBuffer = new StringBuffer();
                Object object = vector.iterator();
                while (object.hasNext()) {
                    ValidationError validationError = (ValidationError)object.next();
                    if (validationError.getDetailedMsg() != null) {
                        stringBuffer.append(validationError.getDetailedMsg() + "\n");
                        continue;
                    }
                    stringBuffer.append(validationError.getMsg() + "\n");
                }
                object = new StringBuffer();
                ((StringBuffer)object).append(ConfigResource.getUiRbString((String)"ValidationErrorDesc") + "\n");
                ((StringBuffer)object).append(stringBuffer);
                JOptionPane.showMessageDialog(this.buttonPanel, ((StringBuffer)object).toString(), ConfigResource.getUiRbString((String)"ValidationErrorTitle"), 0);
                SystemLog.log((String)"ValidationError", (Serializable[])new Serializable[]{stringBuffer.toString()});
                Busy.end();
                return;
            }
            KvpNode kvpNode = new KvpNode();
            KvpNode kvpNode2 = new KvpNode();
            this.getChanges(kvpNode, kvpNode2);
            try {
                if (kvpNode.getAllGroups().size() > 0 && this.includeSettingsFields) {
                    this.device.setSettingTree(kvpNode);
                }
                if (kvpNode2.getAllGroups().size() > 0 && this.includeStateFields) {
                    this.device.setStateTree(kvpNode2);
                }
                this.commitChanges();
                SystemLog.log((String)"Op1Succ", (Serializable[])new Serializable[]{ConfigResource.getUiRbString((String)"SaveChangesMenu")});
            }
            catch (DeviceCommandException deviceCommandException) {
                SystemLog.log((String)"Op1Fail", (Serializable[])new Serializable[]{ConfigResource.getUiRbString((String)"SaveChangesMenu")}, (Throwable)deviceCommandException);
            }
            catch (DeviceValidationException deviceValidationException) {
                SystemLog.debug((String)"Invalid fields detected while saving to device", (Throwable)deviceValidationException);
                KvpNode kvpNode3 = deviceValidationException.getCluster();
                Collection collection = kvpNode3.getErrors();
                StringBuffer stringBuffer = new StringBuffer();
                Object object = collection.iterator();
                while (object.hasNext()) {
                    RciCommandError rciCommandError = (RciCommandError)object.next();
                    stringBuffer.append(rciCommandError.toString() + "\n");
                }
                object = new StringBuffer();
                ((StringBuffer)object).append(ConfigResource.getUiRbString((String)"ValidationErrorDesc") + "\n");
                ((StringBuffer)object).append(stringBuffer);
                JOptionPane.showMessageDialog(this.buttonPanel, ((StringBuffer)object).toString(), ConfigResource.getUiRbString((String)"ValidationErrorTitle"), 0);
                SystemLog.log((String)"ValidationError", (Serializable[])new Serializable[]{stringBuffer.toString()});
                Busy.end();
                return;
            }
        } else {
            SystemLog.log((String)"SaveNotRequired");
        }
        Busy.end();
    }

    public void doCancelChangesAction() {
        this.cancelChanges();
        SystemLog.log((String)"Op1Succ", (Serializable[])new Serializable[]{ConfigResource.getUiRbString((String)"CancelChangesMenu")});
    }

    public void doRefreshAction() {
        Busy.begin((String)ConfigResource.getUiRbString((String)"RefreshStatus"));
        try {
            if (this.includeSettingsFields) {
                this.device.refreshSettingTree();
            }
            if (this.includeStateFields) {
                this.device.refreshStateTree();
            }
            this.cancelChanges();
            SystemLog.log((String)"Op1Succ", (Serializable[])new Serializable[]{ConfigResource.getUiRbString((String)"RefreshMenu")});
        }
        catch (DeviceCommandException deviceCommandException) {
            SystemLog.log((String)"Op1Fail", (Serializable[])new Serializable[]{ConfigResource.getUiRbString((String)"RefreshMenu")}, (Throwable)deviceCommandException);
        }
        Busy.end();
    }

    public void doViewHelpAction() {
        SystemLog.debug((String)"ConfigViewImpl.doHelpAction invoked");
        String string = this.getHelpResource();
        if (string == null) {
            SystemLog.log((String)"NoHelpAvailable");
        } else {
            SystemLog.debug((String)("Launching view help . Help key = " + string));
            HelpDisplay.showHelp((String)string);
        }
    }

    protected Document createIntegerDocument() {
        return new PlainDocument(){

            public void sendBeep() {
                Toolkit.getDefaultToolkit().beep();
            }

            public void insertString(int n, String string, AttributeSet attributeSet) throws BadLocationException {
                if (string == null) {
                    return;
                }
                String string2 = null;
                string2 = this.getLength() == 0 ? string : (n == 0 ? string + this.getText(0, this.getLength()) : (n == this.getLength() - 1 ? this.getText(0, this.getLength()) + string : this.getText(0, n) + string + this.getText(n, this.getLength() - n)));
                if (string2.length() > 5) {
                    this.sendBeep();
                    return;
                }
                if (!string2.matches("^[0-9]+")) {
                    this.sendBeep();
                    return;
                }
                super.insertString(n, new String(string), attributeSet);
            }
        };
    }

    protected Document createNetworkAddressDocument() {
        return new PlainDocument(){

            public void sendBeep() {
                Toolkit.getDefaultToolkit().beep();
            }

            public void insertString(int n, String string, AttributeSet attributeSet) throws BadLocationException {
                if (string == null) {
                    return;
                }
                String string2 = null;
                string2 = this.getLength() == 0 ? string : (n == 0 ? string + this.getText(0, this.getLength()) : (n == this.getLength() - 1 ? this.getText(0, this.getLength()) + string : this.getText(0, n) + string + this.getText(n, this.getLength() - n)));
                if (!string2.matches("^[0-9.]*$")) {
                    this.sendBeep();
                    return;
                }
                String[] stringArray = string2.split("[.]", -1);
                if (stringArray.length > 4) {
                    this.sendBeep();
                    return;
                }
                for (int i = 0; i < stringArray.length; ++i) {
                    if (stringArray[i].length() == 0 || stringArray[i].length() <= 3 && Integer.parseInt(stringArray[i]) <= 255) continue;
                    this.sendBeep();
                    return;
                }
                super.insertString(n, new String(string), attributeSet);
            }
        };
    }

    protected Document createGeneralDocument() {
        return new PlainDocument(){

            public void sendBeep() {
                Toolkit.getDefaultToolkit().beep();
            }

            public void insertString(int n, String string, AttributeSet attributeSet) throws BadLocationException {
                if (string == null) {
                    return;
                }
                if (string.matches("[<>&]")) {
                    this.sendBeep();
                    return;
                }
                super.insertString(n, new String(string), attributeSet);
            }
        };
    }

    protected Document createEmailDocument() {
        return new PlainDocument(){

            public void sendBeep() {
                Toolkit.getDefaultToolkit().beep();
            }

            public void insertString(int n, String string, AttributeSet attributeSet) throws BadLocationException {
                if (string == null) {
                    return;
                }
                String string2 = null;
                string2 = this.getLength() == 0 ? string : (n == 0 ? string + this.getText(0, this.getLength()) : (n == this.getLength() - 1 ? this.getText(0, this.getLength()) + string : this.getText(0, n) + string + this.getText(n, this.getLength() - n)));
                if (!string2.matches("^[a-zA-Z0-9_.@-]*$")) {
                    this.sendBeep();
                    return;
                }
                int n2 = 0;
                for (int i = 0; i < string2.length(); ++i) {
                    if (string2.charAt(i) == '@') {
                        ++n2;
                    }
                    if (n2 <= 1) continue;
                    this.sendBeep();
                    return;
                }
                super.insertString(n, new String(string), attributeSet);
            }
        };
    }
}

