/*
 * Decompiled with CFR 0.152.
 */
package com.digi.config.ui;

import com.digi.config.core.Device;
import com.digi.config.core.DeviceChangeEvent;
import com.digi.config.core.DeviceChangeListener;
import com.digi.config.core.KvpField;
import com.digi.config.core.KvpNode;
import com.digi.config.ui.ConfigViewImpl;
import com.digi.config.ui.GridContentPanel;
import com.digi.config.util.ConfigResource;
import com.digi.config.util.SystemLog;
import java.awt.Component;
import javax.swing.JLabel;

public class GeneralInfoView
extends ConfigViewImpl {
    KvpNode viewStateTree;
    DeviceChangeListener stateChangeListener;
    GridContentPanel content;
    JLabel productName_UIC;
    JLabel macAddr_UIC;
    JLabel firmwareVersion_UIC;
    JLabel bootVersion_UIC;
    JLabel postVersion_UIC;
    JLabel cpuUtil_UIC;
    JLabel upTime_UIC;
    JLabel totalMem_UIC;
    JLabel usedMem_UIC;
    JLabel freeMem_UIC;
    private static final int MINUTES_PER_HOUR = 60;
    private static final int SECONDS_PER_MINUTE = 60;
    private static final int HOURS_PER_DAY = 24;

    public GeneralInfoView() throws Exception {
        super(false);
        this.setIncludeStateFields(true);
        this.setIncludeSettingsFields(false);
        this.viewStateTree = new KvpNode();
        this.stateChangeListener = new DeviceChangeListener(){

            public void deviceChanged(DeviceChangeEvent deviceChangeEvent) {
                GeneralInfoView.this.refreshViewControls();
            }
        };
        this.content = new GridContentPanel(this.getName(), 1);
        this.productName_UIC = this.content.addJLabel("ProductNameLbl", null);
        this.productName_UIC.setText(ConfigResource.getUiRbString((String)"ProductName"));
        this.macAddr_UIC = this.content.addJLabel("MacAddressLbl", null);
        this.firmwareVersion_UIC = this.content.addJLabel("FirmwareVersionLbl", null);
        this.bootVersion_UIC = this.content.addJLabel("BootVersionLbl", null);
        this.postVersion_UIC = this.content.addJLabel("PostVersionLbl", null);
        this.content.addBlankLine();
        this.cpuUtil_UIC = this.content.addJLabel("CpuUtilLbl", null);
        this.upTime_UIC = this.content.addJLabel("UpTimeLbl", null);
        this.totalMem_UIC = this.content.addJLabel("TotalMemoryLbl", null);
        this.usedMem_UIC = this.content.addJLabel("UsedMemoryLbl", null);
        this.freeMem_UIC = this.content.addJLabel("FreeMemoryLbl", null);
        this.content.addVGlue();
    }

    public String getName() {
        return "GeneralInfoView";
    }

    public Component getViewContent() {
        return this.content;
    }

    public void setDevice(Device device) {
        super.setDevice(device);
        this.refreshViewControls();
    }

    private void refreshViewControls() {
        this.viewStateTree.clear();
        KvpNode kvpNode = this.viewStateTree.mergeFrom(this.device.getInternalStateTree(), "device_info", "mac");
        this.refreshUIFromField(this.macAddr_UIC, (KvpField)kvpNode, false);
        kvpNode = this.viewStateTree.mergeFrom(this.device.getInternalStateTree(), "device_info", "firmware");
        this.refreshUIFromField(this.firmwareVersion_UIC, (KvpField)kvpNode, false);
        kvpNode = this.viewStateTree.mergeFrom(this.device.getInternalStateTree(), "device_info", "boot");
        this.refreshUIFromField(this.bootVersion_UIC, (KvpField)kvpNode, false);
        kvpNode = this.viewStateTree.mergeFrom(this.device.getInternalStateTree(), "device_info", "post");
        this.refreshUIFromField(this.postVersion_UIC, (KvpField)kvpNode, false);
        kvpNode = this.viewStateTree.mergeFrom(this.device.getInternalStateTree(), "device_stats", "cpu");
        this.refreshUIFromField(this.cpuUtil_UIC, (KvpField)kvpNode, true);
        kvpNode = this.viewStateTree.mergeFrom(this.device.getInternalStateTree(), "device_stats", "uptime");
        this.refreshUIFromField(this.upTime_UIC, (KvpField)kvpNode, true);
        kvpNode = this.viewStateTree.mergeFrom(this.device.getInternalStateTree(), "device_stats", "totalmem");
        this.refreshUIFromField(this.totalMem_UIC, (KvpField)kvpNode, true);
        kvpNode = this.viewStateTree.mergeFrom(this.device.getInternalStateTree(), "device_stats", "usedmem");
        this.refreshUIFromField(this.usedMem_UIC, (KvpField)kvpNode, true);
        kvpNode = this.viewStateTree.mergeFrom(this.device.getInternalStateTree(), "device_stats", "freemem");
        this.refreshUIFromField(this.freeMem_UIC, (KvpField)kvpNode, true);
    }

    private void refreshUIFromField(JLabel jLabel, KvpField kvpField, boolean bl) {
        jLabel.setEnabled(kvpField != null);
        if (kvpField != null) {
            String string = bl ? this.formatField(kvpField) : kvpField.getStringValue();
            jLabel.setText(string);
        }
    }

    String formatField(KvpField kvpField) {
        String string = kvpField.getStringValue();
        if (kvpField.getName().equals("cpu")) {
            return this.formatCpuUtil(kvpField.getStringValue());
        }
        if (kvpField.getName().equals("uptime")) {
            return this.formatUpTime(kvpField.getStringValue());
        }
        if (kvpField.getName().equals("totalmem") || kvpField.getName().equals("usedmem") || kvpField.getName().equals("freemem")) {
            return this.formatByteSize(kvpField.getStringValue());
        }
        return string;
    }

    String formatCpuUtil(String string) {
        if (string.length() == 0) {
            string = "0";
        }
        return ConfigResource.getUiRbString((String)"CpuUtilFormat", (Object[])new Object[]{string});
    }

    String formatUpTime(String string) {
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        try {
            n = Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        n2 = n / 60;
        if (n2 != 0) {
            n %= 60;
            n3 = n2 / 60;
            if (n3 != 0) {
                n2 %= 60;
                n4 = n3 / 24;
                if (n4 != 0) {
                    n3 %= 24;
                }
            }
        }
        if (n4 > 0) {
            Object[] objectArray = new Object[]{new Integer(n4), new Integer(n3), new Integer(n2), new Integer(n)};
            return ConfigResource.getUiRbString((String)"UpTimeFormatDays", (Object[])objectArray);
        }
        if (n3 > 0) {
            Object[] objectArray = new Object[]{new Integer(n3), new Integer(n2), new Integer(n)};
            return ConfigResource.getUiRbString((String)"UpTimeFormatHours", (Object[])objectArray);
        }
        if (n2 > 0) {
            Object[] objectArray = new Object[]{new Integer(n2), new Integer(n)};
            return ConfigResource.getUiRbString((String)"UpTimeFormatMinutes", (Object[])objectArray);
        }
        Object[] objectArray = new Object[]{new Integer(n)};
        return ConfigResource.getUiRbString((String)"UpTimeFormatSeconds", (Object[])objectArray);
    }

    String formatByteSize(String string) {
        int n = 0;
        try {
            n = Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        int n2 = n / 1024;
        if (n2 > 0) {
            return ConfigResource.getUiRbString((String)"MemorySizeFormatKB", (Object[])new Object[]{new Integer(n2)});
        }
        return ConfigResource.getUiRbString((String)"MemorySizeFormatBytes", (Object[])new Object[]{new Integer(n)});
    }

    public void activate() {
        SystemLog.debug((String)("Activating " + this.getName()));
        this.device.addStateChangeListener(this.stateChangeListener);
        this.doRefreshAction();
    }

    public void deactivate() {
        this.device.removeStateChangeListener(this.stateChangeListener);
    }

    public boolean isChanged() {
        return false;
    }

    public void getChanges(KvpNode kvpNode, KvpNode kvpNode2) {
    }

    public void commitChanges() {
    }

    public void cancelChanges() {
    }
}

