/*
 * Decompiled with CFR 0.152.
 */
package com.digi.config.ui;

import com.digi.config.core.Controller;
import com.digi.config.ui.ConfigAction;
import com.digi.config.ui.ControllerListModel;
import com.digi.config.ui.CustomPanel;
import com.digi.config.ui.MessageLogFilter;
import com.digi.config.util.ConfigResource;
import com.digi.config.util.ConfigSettings;
import com.digi.config.util.SystemLog;
import com.digi.config.util.SystemLogCtlr;
import com.digi.config.util.SystemLogEntry;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Calendar;
import java.util.StringTokenizer;
import javax.swing.DefaultListCellRenderer;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JList;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.ListCellRenderer;
import javax.swing.SwingUtilities;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;

public class MessageArea
extends CustomPanel
implements ListDataListener {
    private static ImageIcon fatalIcon = null;
    private static ImageIcon errorIcon = null;
    private static ImageIcon warningIcon = null;
    private static ImageIcon informationIcon = null;
    private static ImageIcon debugIcon = null;
    private static ImageIcon detailFatalIcon = null;
    private static ImageIcon detailErrorIcon = null;
    private static ImageIcon detailWarningIcon = null;
    private static ImageIcon detailInformationIcon = null;
    private static ImageIcon detailDebugIcon = null;
    private static BasicMsgFrame detailFrame = null;
    SystemLogCtlr systemLogCtlr;
    JList logList;
    JScrollPane scrollPane;
    ControllerListModel logListModel;
    MessageLogFilter logFilter;
    long clearTime;
    boolean priorMessageFilter;
    int minimumSeverityFilter;
    JPopupMenu popupMenu;
    protected ConfigAction clearLogAction;
    protected ConfigAction refreshLogAction;
    protected ConfigAction setMinimumSeverityFatalFilterAction;
    protected ConfigAction setMinimumSeverityErrorFilterAction;
    protected ConfigAction setMinimumSeverityWarningFilterAction;
    protected ConfigAction setMinimumSeverityInformationFilterAction;
    protected ConfigAction setMinimumSeverityDebugFilterAction;

    public MessageArea() throws Exception {
        super("Message");
        this.setLayout(new BorderLayout());
        fatalIcon = ConfigResource.getImageRbIcon((String)"FatalImage");
        errorIcon = ConfigResource.getImageRbIcon((String)"ErrorImage");
        warningIcon = ConfigResource.getImageRbIcon((String)"WarningImage");
        informationIcon = ConfigResource.getImageRbIcon((String)"InformationImage");
        debugIcon = ConfigResource.getImageRbIcon((String)"DebugImage");
        detailFatalIcon = ConfigResource.getImageRbIcon((String)"DetailedFatalImage");
        detailErrorIcon = ConfigResource.getImageRbIcon((String)"DetailedErrorImage");
        detailWarningIcon = ConfigResource.getImageRbIcon((String)"DetailedWarningImage");
        detailInformationIcon = ConfigResource.getImageRbIcon((String)"DetailedInformationImage");
        detailDebugIcon = ConfigResource.getImageRbIcon((String)"DetailedDebugImage");
        this.systemLogCtlr = SystemLog.getSystemLogCtlr();
        this.logListModel = new ControllerListModel((Controller)this.systemLogCtlr);
        this.clearTime = Calendar.getInstance().getTime().getTime();
        this.logFilter = new MessageLogFilter();
        this.logListModel.addFilter(this.logFilter);
        this.setPriorMessageFilter(ConfigSettings.getBoolean((String)"WindowSettings", (String)"MessageAreaPriorMessageFilter"));
        this.setMinimumSeverityFilter(ConfigSettings.getInteger((String)"WindowSettings", (String)"MessageAreaMinimumSeverityFilter"));
        this.logList = new JList(this.logListModel);
        this.logList.setOpaque(false);
        this.logList.setSelectionBackground(Color.BLACK);
        this.logList.setSelectionForeground(Color.WHITE);
        this.logList.setBackground(new Color(0, 0, 0));
        this.logListModel.addListDataListener(this);
        this.logList.setCellRenderer(new LogListRenderer());
        this.logList.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                if (mouseEvent.getClickCount() == 2) {
                    SystemLogEntry.ExceptionInfo exceptionInfo;
                    SystemLogEntry systemLogEntry = null;
                    try {
                        systemLogEntry = (SystemLogEntry)MessageArea.this.logList.getSelectedValue();
                    }
                    catch (Exception exception) {
                        return;
                    }
                    if (systemLogEntry == null) {
                        return;
                    }
                    String string = System.getProperty("line.separator");
                    StringBuffer stringBuffer = new StringBuffer();
                    stringBuffer.append("MsgId: " + systemLogEntry.getServiceId() + string);
                    stringBuffer.append("Time: " + systemLogEntry.getCreationTime().getTime().toString() + string);
                    stringBuffer.append("System: " + systemLogEntry.getSystemName() + string);
                    stringBuffer.append("Severity: " + systemLogEntry.getSeverity() + string + string);
                    stringBuffer.append("Text: " + systemLogEntry.getMsg() + string + string);
                    if (systemLogEntry.hasDetailedMsg()) {
                        stringBuffer.append("Detailed Description: " + systemLogEntry.getDetailedMsg() + string + string);
                    }
                    if ((exceptionInfo = systemLogEntry.getExceptionInfo()) != null) {
                        stringBuffer.append("Exception Information:" + string + exceptionInfo.callStack);
                    }
                    if (detailFrame == null) {
                        String string2 = ConfigResource.getUiRbString((String)"MsgDetailsFrameTitle");
                        detailFrame = new BasicMsgFrame(string2);
                    }
                    detailFrame.showText(stringBuffer.toString());
                }
            }
        });
        this.scrollPane = new JScrollPane(this.logList);
        this.scrollPane.setOpaque(false);
        this.scrollPane.getViewport().setOpaque(false);
        this.add(this.scrollPane, "Center");
        int n = ConfigSettings.getInteger((String)"WindowSettings", (String)"MessageAreaWidth");
        int n2 = ConfigSettings.getInteger((String)"WindowSettings", (String)"MessageAreaHeight");
        this.setSize(n, n2);
        this.defineActions();
        this.addPopupMenu();
    }

    public void saveLayout() {
        ConfigSettings.setInteger((String)"WindowSettings", (String)"MessageAreaWidth", (int)this.getWidth());
        ConfigSettings.setInteger((String)"WindowSettings", (String)"MessageAreaHeight", (int)this.getHeight());
    }

    public void setPriorMessageFilter(boolean bl) {
        this.priorMessageFilter = bl;
        if (bl) {
            this.logFilter.setMinimumCreateTime(this.clearTime);
        } else {
            this.logFilter.setMinimumCreateTime(0L);
        }
        this.logListModel.updateFilter(this.logFilter);
        ConfigSettings.setBoolean((String)"WindowSettings", (String)"MessageAreaPriorMessageFilter", (boolean)this.priorMessageFilter);
    }

    public void setMinimumSeverityFilter(int n) {
        this.minimumSeverityFilter = n;
        this.logFilter.setMinimumSeverity(n);
        this.logListModel.updateFilter(this.logFilter);
        ConfigSettings.setInteger((String)"WindowSettings", (String)"MessageAreaMinimumSeverityFilter", (int)this.minimumSeverityFilter);
    }

    private void defineActions() throws Exception {
        this.clearLogAction = new ConfigAction("ClearLog", this, "doClearLogAction");
        this.refreshLogAction = new ConfigAction("RefreshLog", this, "doRefreshLogAction");
        this.setMinimumSeverityFatalFilterAction = new ConfigAction("Fatal", this, "doSetMinimumSeverityFatalFilterAction");
        this.setMinimumSeverityErrorFilterAction = new ConfigAction("Error", this, "doSetMinimumSeverityErrorFilterAction");
        this.setMinimumSeverityWarningFilterAction = new ConfigAction("Warning", this, "doSetMinimumSeverityWarningFilterAction");
        this.setMinimumSeverityInformationFilterAction = new ConfigAction("Information", this, "doSetMinimumSeverityInformationFilterAction");
        this.setMinimumSeverityDebugFilterAction = new ConfigAction("Debug", this, "doSetMinimumSeverityDebugFilterAction");
    }

    public JMenu getLogMenu() {
        String string = ConfigResource.getUiRbString((String)"LogMenu");
        JMenu jMenu = new JMenu(string);
        jMenu.setMnemonic(ConfigResource.getUiRbString((String)"LogMnemonic").charAt(0));
        JMenuItem jMenuItem = jMenu.add(this.clearLogAction);
        this.clearLogAction.addDecorations(jMenuItem);
        jMenuItem = jMenu.add(this.refreshLogAction);
        this.refreshLogAction.addDecorations(jMenuItem);
        JMenu jMenu2 = new JMenu(ConfigResource.getUiRbString((String)"MinimumSeverityMenu"));
        jMenu2.setToolTipText(ConfigResource.getUiRbString((String)"MinimumSeverityTip"));
        jMenu2.setMnemonic(ConfigResource.getUiRbString((String)"MinimumSeverityMnemonic").charAt(0));
        jMenu2.add(this.setMinimumSeverityFatalFilterAction);
        jMenu2.add(this.setMinimumSeverityErrorFilterAction);
        jMenu2.add(this.setMinimumSeverityWarningFilterAction);
        jMenu2.add(this.setMinimumSeverityInformationFilterAction);
        jMenu2.add(this.setMinimumSeverityDebugFilterAction);
        jMenuItem = jMenu.add(jMenu2);
        return jMenu;
    }

    public void addPopupMenu() {
        JMenuItem jMenuItem = null;
        this.popupMenu = new JPopupMenu();
        jMenuItem = this.popupMenu.add(this.clearLogAction);
        this.clearLogAction.addDecorations(jMenuItem);
        jMenuItem = this.popupMenu.add(this.refreshLogAction);
        this.refreshLogAction.addDecorations(jMenuItem);
        JMenu jMenu = new JMenu(ConfigResource.getUiRbString((String)"MinimumSeverityMenu"));
        jMenu.setToolTipText(ConfigResource.getUiRbString((String)"MinimumSeverityTip"));
        jMenu.setMnemonic(ConfigResource.getUiRbString((String)"MinimumSeverityMnemonic").charAt(0));
        jMenu.add(this.setMinimumSeverityFatalFilterAction);
        jMenu.add(this.setMinimumSeverityErrorFilterAction);
        jMenu.add(this.setMinimumSeverityWarningFilterAction);
        jMenu.add(this.setMinimumSeverityInformationFilterAction);
        jMenu.add(this.setMinimumSeverityDebugFilterAction);
        jMenuItem = this.popupMenu.add(jMenu);
        this.logList.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                if (SwingUtilities.isRightMouseButton(mouseEvent)) {
                    MessageArea.this.popupMenu.show(MessageArea.this.logList, mouseEvent.getX(), mouseEvent.getY());
                }
            }
        });
    }

    public void doClearLogAction() throws Exception {
        this.clearTime = Calendar.getInstance().getTime().getTime();
        this.setPriorMessageFilter(true);
    }

    public void doRefreshLogAction() throws Exception {
        this.setPriorMessageFilter(false);
    }

    public void doSetMinimumSeverityFatalFilterAction() throws Exception {
        this.setMinimumSeverityFilter(4);
    }

    public void doSetMinimumSeverityErrorFilterAction() throws Exception {
        this.setMinimumSeverityFilter(3);
    }

    public void doSetMinimumSeverityWarningFilterAction() throws Exception {
        this.setMinimumSeverityFilter(2);
    }

    public void doSetMinimumSeverityInformationFilterAction() throws Exception {
        this.setMinimumSeverityFilter(1);
    }

    public void doSetMinimumSeverityDebugFilterAction() throws Exception {
        this.setMinimumSeverityFilter(0);
    }

    public void contentsChanged(ListDataEvent listDataEvent) {
    }

    public void intervalAdded(ListDataEvent listDataEvent) {
        final int n = this.logListModel.getSize();
        if (n > 0) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    MessageArea.this.logList.ensureIndexIsVisible(n - 1);
                }
            });
        }
    }

    public void intervalRemoved(ListDataEvent listDataEvent) {
    }

    public class BasicMsgFrame
    extends JFrame {
        JTextArea textArea;

        public BasicMsgFrame(String string) {
            super(string);
            this.setBackground(ConfigSettings.getColor((String)"WindowSettings", (String)"BackgroundColor"));
            this.setDefaultCloseOperation(1);
            this.textArea = new JTextArea(20, 100);
            this.textArea.setEditable(false);
            JScrollPane jScrollPane = new JScrollPane(this.textArea);
            jScrollPane.setOpaque(false);
            jScrollPane.getViewport().setOpaque(false);
            this.getContentPane().add((Component)jScrollPane, "Center");
        }

        public void showText(String string) {
            this.textArea.setText(string);
            this.textArea.setCaretPosition(0);
            this.pack();
            this.setVisible(true);
        }

        public void showText(String string, Color color) {
            this.textArea.setText(string);
            this.textArea.setBackground(color);
            this.textArea.setCaretPosition(0);
            this.pack();
            this.setVisible(true);
        }
    }

    private class LogListRenderer
    extends DefaultListCellRenderer
    implements ListCellRenderer {
        public static final String NEWLINE = "\n";

        public LogListRenderer() {
            this.setOpaque(false);
        }

        public ImageIcon getImageIcon(Object object) {
            ImageIcon imageIcon = informationIcon;
            SystemLogEntry systemLogEntry = (SystemLogEntry)object;
            switch (systemLogEntry.getSeverity()) {
                case 4: {
                    if (systemLogEntry.hasDetailedMsg()) {
                        imageIcon = detailFatalIcon;
                        break;
                    }
                    imageIcon = fatalIcon;
                    break;
                }
                case 3: {
                    if (systemLogEntry.hasDetailedMsg()) {
                        imageIcon = detailErrorIcon;
                        break;
                    }
                    imageIcon = errorIcon;
                    break;
                }
                case 2: {
                    if (systemLogEntry.hasDetailedMsg()) {
                        imageIcon = detailWarningIcon;
                        break;
                    }
                    imageIcon = warningIcon;
                    break;
                }
                case 1: {
                    if (!systemLogEntry.hasDetailedMsg()) break;
                    imageIcon = detailInformationIcon;
                    break;
                }
                case 0: {
                    if (systemLogEntry.hasDetailedMsg()) {
                        imageIcon = detailDebugIcon;
                        break;
                    }
                    imageIcon = debugIcon;
                    break;
                }
            }
            return imageIcon;
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            SystemLogEntry systemLogEntry = (SystemLogEntry)object;
            ImageIcon imageIcon = this.getImageIcon(object);
            this.setIcon(imageIcon);
            if (bl) {
                this.setOpaque(true);
                this.setBackground(jList.getSelectionBackground());
                this.setForeground(jList.getSelectionForeground());
                if (systemLogEntry.hasDetailedMsg()) {
                    String string = systemLogEntry.getDetailedMsg();
                    StringTokenizer stringTokenizer = new StringTokenizer(string, NEWLINE, false);
                    if (stringTokenizer.countTokens() > 2) {
                        string = stringTokenizer.nextToken();
                    }
                    jList.setToolTipText(string);
                } else {
                    jList.setToolTipText(null);
                }
            } else {
                this.setOpaque(false);
                this.setBackground(jList.getBackground());
                this.setForeground(jList.getForeground());
            }
            this.setFont(jList.getFont());
            this.setText(systemLogEntry == null ? "" : systemLogEntry.getMsg());
            return this;
        }
    }
}

