/*
 * Decompiled with CFR 0.152.
 */
package com.digi.config.ui;

import com.digi.config.core.Device;
import com.digi.config.core.DeviceCommandException;
import com.digi.config.core.KvpNode;
import com.digi.config.ui.ConfigAction;
import com.digi.config.ui.ConfigViewImpl;
import com.digi.config.ui.GridContentPanel;
import com.digi.config.util.Busy;
import com.digi.config.util.ConfigResource;
import com.digi.config.util.SystemLog;
import java.awt.Component;
import java.io.Serializable;
import javax.swing.Action;
import javax.swing.JOptionPane;

public class RebootView
extends ConfigViewImpl {
    GridContentPanel content = new GridContentPanel(1);

    public RebootView() throws Exception {
        this.content.addTextLine("RebootHeading");
        this.content.addAction(null, (Action)new ConfigAction("Reboot", this, "doRebootAction"), "RebootDesc");
        this.content.addVGlue();
    }

    public void doRebootAction() {
        int n = JOptionPane.showConfirmDialog((Component)this.content, ConfigResource.getUiRbString((String)"RebootConfirm"), ConfigResource.getUiRbString((String)"RebootViewTitle"), 0);
        if (n != 0) {
            return;
        }
        Busy.begin((String)ConfigResource.getUiRbString((String)"RebootStatus"));
        try {
            this.device.reboot();
            SystemLog.log((String)"Op1Succ", (Serializable[])new Serializable[]{ConfigResource.getUiRbString((String)"RebootMenu")});
        }
        catch (DeviceCommandException deviceCommandException) {
            SystemLog.log((String)"Op1Fail", (Serializable[])new Serializable[]{ConfigResource.getUiRbString((String)"RebootMenu")}, (Throwable)deviceCommandException);
        }
        Busy.end();
    }

    public String getName() {
        return "RebootView";
    }

    public Component getViewContent() {
        return this.content;
    }

    public Component getViewButtons() {
        return null;
    }

    public void setDevice(Device device) {
        super.setDevice(device);
    }

    public void activate() {
        SystemLog.debug((String)"Activating RebootView");
    }

    public void deactivate() {
        SystemLog.debug((String)"Deactivating RebootView");
    }

    public boolean isChanged() {
        return false;
    }

    public void getChanges(KvpNode kvpNode, KvpNode kvpNode2) {
    }

    public void commitChanges() {
    }

    public void cancelChanges() {
    }
}

