/*
 * Decompiled with CFR 0.152.
 */
package com.digi.config.ui;

import com.digi.config.core.Device;
import com.digi.config.core.DeviceChangeEvent;
import com.digi.config.core.DeviceChangeListener;
import com.digi.config.core.KvpField;
import com.digi.config.core.KvpNode;
import com.digi.config.core.RciProtocol;
import com.digi.config.core.ValidationError;
import com.digi.config.core.ValidationHelper;
import com.digi.config.ui.ConfigViewImpl;
import com.digi.config.ui.ControlChangeAdapter;
import com.digi.config.ui.GridContentPanel;
import com.digi.config.util.SystemLog;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.io.Serializable;
import java.net.InetAddress;
import java.util.Collection;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextField;

public class SerialPortServicesView
extends ConfigViewImpl {
    KvpNode viewSettingTree;
    DeviceChangeListener settingChangeListener;
    GridContentPanel content;
    GridContentPanel tcpClientContent;
    GridContentPanel tcpConnectOnContent;
    GridContentPanel tcpConnectOnDataContent;
    GridContentPanel tcpConnectToContent;
    GridContentPanel udpClientContent;
    GridContentPanel udpSendOnContent;
    GridContentPanel udpSendOnDataContent;
    GridContentPanel udpSopCustomContent;
    GridContentPanel udpSatContent;
    GridContentPanel udpSabContent;
    GridContentPanel udpSendToContent;
    int MAXDESTINATIONS = 64;
    KvpField tcpAutoConnectEnabledKvpField;
    KvpField tcpConnectTriggerKvpField;
    KvpField tcpConnectOnDataPatternKvpField;
    KvpField tcpConnectOnDataStripPatternKvpField;
    KvpField tcpConnectToAddressKvpField;
    KvpField tcpConnectToProtocolKvpField;
    KvpField tcpConnectToPortKvpField;
    KvpField udpClientEnabledKvpField;
    KvpField[] udpSendToEnabledKvpField = new KvpField[this.MAXDESTINATIONS];
    KvpField[] udpSendToAddressKvpField = new KvpField[this.MAXDESTINATIONS];
    KvpField[] udpSendToPortKvpField = new KvpField[this.MAXDESTINATIONS];
    KvpField[] udpSendToDescKvpField = new KvpField[this.MAXDESTINATIONS];
    KvpField udpSendOnDataEnabledKvpField;
    KvpField udpSendOnDataPatternKvpField;
    KvpField udpSendOnDataStripPatternKvpField;
    KvpField udpSatEnabledKvpField;
    KvpField udpSatValueKvpField;
    KvpField udpSabEnabledKvpField;
    KvpField udpSabValueKvpField;
    JCheckBox tcpAutoConnectEnabled_UIC;
    JRadioButton tcpConnectOnAlways_UIC;
    JRadioButton tcpConnectOnData_UIC;
    JRadioButton tcpConnectOnDSR_UIC;
    JRadioButton tcpConnectOnDCD_UIC;
    JTextField tcpConnectOnDataPattern_UIC;
    JMenuItem tcpConnectOnDataPatternCR_UIC;
    JMenuItem tcpConnectOnDataPatternCRLF_UIC;
    JCheckBox tcpConnectOnDataStripPattern_UIC;
    JTextField tcpConnectToAddress_UIC;
    JComboBox tcpConnectToProtocol_UIC;
    JTextField tcpConnectToPort_UIC;
    JCheckBox udpClientEnabled_UIC;
    JCheckBox[] udpSendToEnabled_UIC = new JCheckBox[this.MAXDESTINATIONS];
    JTextField[] udpSendToAddress_UIC = new JTextField[this.MAXDESTINATIONS];
    JTextField[] udpSendToPort_UIC = new JTextField[this.MAXDESTINATIONS];
    JTextField[] udpSendToDesc_UIC = new JTextField[this.MAXDESTINATIONS];
    JCheckBox udpSendOnDataEnabled_UIC;
    JTextField udpSendOnDataPattern_UIC;
    JMenuItem udpSendOnDataPatternCR_UIC;
    JMenuItem udpSendOnDataPatternCRLF_UIC;
    JCheckBox udpSendOnDataStripPattern_UIC;
    JCheckBox udpSatEnabled_UIC;
    JTextField udpSatValue_UIC;
    JCheckBox udpSabEnabled_UIC;
    JTextField udpSabValue_UIC;

    public SerialPortServicesView() throws Exception {
        this.viewSettingTree = new KvpNode();
        this.settingChangeListener = new DeviceChangeListener(){

            public void deviceChanged(DeviceChangeEvent deviceChangeEvent) {
                SystemLog.debug((String)"SerialPortServicesView was notified that device kvpGroup changed");
                SerialPortServicesView.this.refreshViewKvpNode();
                SerialPortServicesView.this.refreshViewControls();
            }
        };
        this.content = new GridContentPanel(this.getName(), 1);
        ControlChangeAdapter controlChangeAdapter = new ControlChangeAdapter(){

            public void changePerformed(Object object, ActionEvent actionEvent, FocusEvent focusEvent) {
                block41: {
                    block45: {
                        block44: {
                            block43: {
                                block42: {
                                    block40: {
                                        if (object != SerialPortServicesView.this.tcpAutoConnectEnabled_UIC) break block40;
                                        SerialPortServicesView.this.tcpAutoConnectEnabledKvpField.setStringValue(RciProtocol.toString((boolean)SerialPortServicesView.this.tcpAutoConnectEnabled_UIC.isSelected()));
                                        break block41;
                                    }
                                    if (object != SerialPortServicesView.this.tcpConnectOnAlways_UIC) break block42;
                                    if (!SerialPortServicesView.this.tcpConnectOnAlways_UIC.isSelected()) break block41;
                                    SerialPortServicesView.this.tcpConnectTriggerKvpField.setStringValue("always");
                                    break block41;
                                }
                                if (object != SerialPortServicesView.this.tcpConnectOnData_UIC) break block43;
                                if (!SerialPortServicesView.this.tcpConnectOnData_UIC.isSelected()) break block41;
                                if (SerialPortServicesView.this.tcpConnectOnDataPattern_UIC.getText().length() > 0) {
                                    SerialPortServicesView.this.tcpConnectTriggerKvpField.setStringValue("string");
                                } else {
                                    SerialPortServicesView.this.tcpConnectTriggerKvpField.setStringValue("data");
                                }
                                break block41;
                            }
                            if (object != SerialPortServicesView.this.tcpConnectOnDSR_UIC) break block44;
                            if (!SerialPortServicesView.this.tcpConnectOnDSR_UIC.isSelected()) break block41;
                            SerialPortServicesView.this.tcpConnectTriggerKvpField.setStringValue("dsr");
                            break block41;
                        }
                        if (object != SerialPortServicesView.this.tcpConnectOnDCD_UIC) break block45;
                        if (!SerialPortServicesView.this.tcpConnectOnDCD_UIC.isSelected()) break block41;
                        SerialPortServicesView.this.tcpConnectTriggerKvpField.setStringValue("dcd");
                        break block41;
                    }
                    if (object == SerialPortServicesView.this.tcpConnectOnDataPattern_UIC) {
                        SerialPortServicesView.this.tcpConnectOnDataPatternKvpField.setStringValue(SerialPortServicesView.this.tcpConnectOnDataPattern_UIC.getText());
                        if (SerialPortServicesView.this.tcpConnectOnDataPattern_UIC.getText().length() > 0) {
                            SerialPortServicesView.this.tcpConnectTriggerKvpField.setStringValue("string");
                        } else {
                            SerialPortServicesView.this.tcpConnectTriggerKvpField.setStringValue("data");
                        }
                    } else if (object == SerialPortServicesView.this.tcpConnectOnDataPatternCR_UIC) {
                        SerialPortServicesView.this.tcpConnectOnDataPattern_UIC.replaceSelection("\\r");
                        SerialPortServicesView.this.tcpConnectOnDataPatternKvpField.setStringValue(SerialPortServicesView.this.tcpConnectOnDataPattern_UIC.getText());
                        SerialPortServicesView.this.tcpConnectTriggerKvpField.setStringValue("string");
                    } else if (object == SerialPortServicesView.this.tcpConnectOnDataPatternCRLF_UIC) {
                        SerialPortServicesView.this.tcpConnectOnDataPattern_UIC.replaceSelection("\\r\\n");
                        SerialPortServicesView.this.tcpConnectOnDataPatternKvpField.setStringValue(SerialPortServicesView.this.tcpConnectOnDataPattern_UIC.getText());
                        SerialPortServicesView.this.tcpConnectTriggerKvpField.setStringValue("string");
                    } else if (object == SerialPortServicesView.this.tcpConnectOnDataStripPattern_UIC) {
                        SerialPortServicesView.this.tcpConnectOnDataStripPatternKvpField.setStringValue(RciProtocol.toString((boolean)SerialPortServicesView.this.tcpConnectOnDataStripPattern_UIC.isSelected()));
                    } else if (object == SerialPortServicesView.this.tcpConnectToAddress_UIC) {
                        SerialPortServicesView.this.tcpConnectToAddressKvpField.setStringValue(SerialPortServicesView.this.tcpConnectToAddress_UIC.getText());
                    } else if (object == SerialPortServicesView.this.tcpConnectToProtocol_UIC) {
                        SerialPortServicesView.this.tcpConnectToProtocolKvpField.setStringValue(SerialPortServicesView.this.tcpConnectToProtocol_UIC.getSelectedItem().toString());
                    } else if (object == SerialPortServicesView.this.tcpConnectToPort_UIC) {
                        SerialPortServicesView.this.tcpConnectToPortKvpField.setStringValue(SerialPortServicesView.this.tcpConnectToPort_UIC.getText());
                    } else if (object == SerialPortServicesView.this.udpClientEnabled_UIC) {
                        SerialPortServicesView.this.udpClientEnabledKvpField.setStringValue(RciProtocol.toString((boolean)SerialPortServicesView.this.udpClientEnabled_UIC.isSelected()));
                    } else if (object == SerialPortServicesView.this.udpSendOnDataEnabled_UIC) {
                        SerialPortServicesView.this.udpSendOnDataEnabledKvpField.setStringValue(RciProtocol.toString((boolean)SerialPortServicesView.this.udpSendOnDataEnabled_UIC.isSelected()));
                    } else if (object == SerialPortServicesView.this.udpSendOnDataPattern_UIC) {
                        SerialPortServicesView.this.udpSendOnDataPatternKvpField.setStringValue(SerialPortServicesView.this.udpSendOnDataPattern_UIC.getText());
                    } else if (object == SerialPortServicesView.this.udpSendOnDataPatternCR_UIC) {
                        SerialPortServicesView.this.udpSendOnDataPattern_UIC.replaceSelection("\\r");
                        SerialPortServicesView.this.udpSendOnDataPatternKvpField.setStringValue(SerialPortServicesView.this.udpSendOnDataPattern_UIC.getText());
                    } else if (object == SerialPortServicesView.this.udpSendOnDataPatternCRLF_UIC) {
                        SerialPortServicesView.this.udpSendOnDataPattern_UIC.replaceSelection("\\r\\n");
                        SerialPortServicesView.this.udpSendOnDataPatternKvpField.setStringValue(SerialPortServicesView.this.udpSendOnDataPattern_UIC.getText());
                    } else if (object == SerialPortServicesView.this.udpSendOnDataStripPattern_UIC) {
                        SerialPortServicesView.this.udpSendOnDataStripPatternKvpField.setStringValue(RciProtocol.toString((boolean)SerialPortServicesView.this.udpSendOnDataStripPattern_UIC.isSelected()));
                    } else if (object == SerialPortServicesView.this.udpSatEnabled_UIC) {
                        SerialPortServicesView.this.udpSatEnabledKvpField.setStringValue(RciProtocol.toString((boolean)SerialPortServicesView.this.udpSatEnabled_UIC.isSelected()));
                    } else if (object == SerialPortServicesView.this.udpSatValue_UIC) {
                        SerialPortServicesView.this.udpSatValueKvpField.setStringValue(SerialPortServicesView.this.udpSatValue_UIC.getText());
                    } else if (object == SerialPortServicesView.this.udpSabValue_UIC) {
                        SerialPortServicesView.this.udpSabValueKvpField.setStringValue(SerialPortServicesView.this.udpSabValue_UIC.getText());
                    } else {
                        for (int i = 0; i < SerialPortServicesView.this.MAXDESTINATIONS; ++i) {
                            if (object == SerialPortServicesView.this.udpSendToEnabled_UIC[i]) {
                                SerialPortServicesView.this.udpSendToEnabledKvpField[i].setStringValue(RciProtocol.toString((boolean)SerialPortServicesView.this.udpSendToEnabled_UIC[i].isSelected()));
                                break;
                            }
                            if (object == SerialPortServicesView.this.udpSendToAddress_UIC[i]) {
                                SerialPortServicesView.this.udpSendToAddressKvpField[i].setStringValue(SerialPortServicesView.this.udpSendToAddress_UIC[i].getText());
                                break;
                            }
                            if (object == SerialPortServicesView.this.udpSendToPort_UIC[i]) {
                                SerialPortServicesView.this.udpSendToPortKvpField[i].setStringValue(SerialPortServicesView.this.udpSendToPort_UIC[i].getText());
                                break;
                            }
                            if (object != SerialPortServicesView.this.udpSendToDesc_UIC[i]) continue;
                            SerialPortServicesView.this.udpSendToDescKvpField[i].setStringValue(SerialPortServicesView.this.udpSendToDesc_UIC[i].getText());
                            break;
                        }
                    }
                }
                SerialPortServicesView.this.refreshViewControlStates();
            }
        };
        this.content.addTextLine("SerialPortServicesDesc");
        this.content.addHeadingBar("TcpClientHeading");
        this.content.addTextLine("TcpClientDesc");
        this.tcpAutoConnectEnabled_UIC = this.content.addJCheckBox("TcpAutoConnectEnabled", (ActionListener)controlChangeAdapter);
        this.tcpClientContent = new GridContentPanel(1);
        this.tcpClientContent.addTextLine("TcpConnectOnConditionDesc");
        this.tcpConnectOnContent = new GridContentPanel(1);
        this.tcpConnectOnAlways_UIC = this.tcpConnectOnContent.addJRadioButton("TcpConnectOnAlways", (ActionListener)controlChangeAdapter);
        this.tcpConnectOnData_UIC = this.tcpConnectOnContent.addJRadioButton("TcpConnectOnData", (ActionListener)controlChangeAdapter);
        this.tcpConnectOnDataContent = new GridContentPanel(3);
        this.tcpConnectOnContent.addSubPanel((JComponent)this.tcpConnectOnDataContent);
        this.tcpConnectOnDSR_UIC = this.tcpConnectOnContent.addJRadioButton("TcpConnectOnDSR", (ActionListener)controlChangeAdapter);
        this.tcpConnectOnDCD_UIC = this.tcpConnectOnContent.addJRadioButton("TcpConnectOnDCD", (ActionListener)controlChangeAdapter);
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.tcpConnectOnAlways_UIC);
        buttonGroup.add(this.tcpConnectOnData_UIC);
        buttonGroup.add(this.tcpConnectOnDSR_UIC);
        buttonGroup.add(this.tcpConnectOnDCD_UIC);
        this.tcpClientContent.addSubPanel((JComponent)this.tcpConnectOnContent);
        this.tcpConnectOnDataPattern_UIC = this.tcpConnectOnDataContent.addJTextField("TcpConnectOnDataPattern", null, 100, (FocusListener)controlChangeAdapter, 0, false);
        this.tcpConnectOnDataPattern_UIC.setDocument(this.createGeneralDocument());
        JMenuBar jMenuBar = new JMenuBar();
        JMenu jMenu = jMenuBar.add(new JMenu("insert special"));
        this.tcpConnectOnDataPatternCR_UIC = jMenu.add(new JMenuItem("Carriage Return"));
        this.tcpConnectOnDataPatternCR_UIC.addActionListener(controlChangeAdapter);
        this.tcpConnectOnDataPatternCRLF_UIC = jMenu.add(new JMenuItem("Carriage Return/Line Feed"));
        this.tcpConnectOnDataPatternCRLF_UIC.addActionListener(controlChangeAdapter);
        this.tcpConnectOnDataContent.addField(null, (Component)jMenuBar, null, 1, false);
        this.tcpConnectOnDataStripPattern_UIC = this.tcpConnectOnDataContent.addJCheckBox("TcpConnectOnDataStripPattern", (ActionListener)controlChangeAdapter, 2, true);
        this.tcpClientContent.addTextLine("TcpConnectToDesc");
        this.tcpConnectToContent = new GridContentPanel(3);
        this.tcpConnectToAddress_UIC = this.tcpConnectToContent.addJTextField("TcpConnectToAddress", null, 100, (FocusListener)controlChangeAdapter, 0, false);
        this.tcpConnectToAddress_UIC.setDocument(this.createGeneralDocument());
        String[] stringArray = new String[]{"raw", "telnet", "ssl"};
        this.tcpConnectToProtocol_UIC = this.tcpConnectToContent.addJComboBox("TcpConnectToProtocol", null, stringArray, (ActionListener)controlChangeAdapter, 1, false);
        this.tcpConnectToPort_UIC = this.tcpConnectToContent.addJTextField("TcpConnectToPort", null, 100, (FocusListener)controlChangeAdapter, 2, true);
        this.tcpConnectToPort_UIC.setDocument(this.createGeneralDocument());
        this.tcpClientContent.addSubPanel((JComponent)this.tcpConnectToContent);
        this.content.addSubPanel((JComponent)this.tcpClientContent);
        this.content.addHeadingBar("UdpClientHeading");
        this.content.addTextLine("UdpClientDesc");
        this.udpClientEnabled_UIC = this.content.addJCheckBox("UdpClientEnabled", (ActionListener)controlChangeAdapter);
        this.udpClientContent = new GridContentPanel(1);
        this.udpClientContent.addTextLine("UdpSendOnConditionDesc");
        this.udpSendOnContent = new GridContentPanel(1);
        this.udpSendOnDataEnabled_UIC = this.udpSendOnContent.addJCheckBox("UdpSendOnDataEnabled", (ActionListener)controlChangeAdapter);
        this.udpSendOnDataContent = new GridContentPanel(3);
        this.udpSendOnContent.addSubPanel((JComponent)this.udpSendOnDataContent);
        this.udpSendOnDataPattern_UIC = this.udpSendOnDataContent.addJTextField("UdpSendOnDataPattern", null, 100, (FocusListener)controlChangeAdapter, 0, false);
        this.udpSendOnDataPattern_UIC.setDocument(this.createGeneralDocument());
        JMenuBar jMenuBar2 = new JMenuBar();
        JMenu jMenu2 = jMenuBar2.add(new JMenu("insert special"));
        this.udpSendOnDataPatternCR_UIC = jMenu2.add(new JMenuItem("Carriage Return"));
        this.udpSendOnDataPatternCR_UIC.addActionListener(controlChangeAdapter);
        this.udpSendOnDataPatternCRLF_UIC = jMenu2.add(new JMenuItem("Carriage Return/Line Feed"));
        this.udpSendOnDataPatternCRLF_UIC.addActionListener(controlChangeAdapter);
        this.udpSendOnDataContent.addField(null, (Component)jMenuBar2, null, 1, false);
        this.udpSendOnDataStripPattern_UIC = this.udpSendOnDataContent.addJCheckBox("UdpSendOnDataStripPattern", (ActionListener)controlChangeAdapter, 2, true);
        this.udpSendOnContent.addSubPanel((JComponent)this.udpSendOnDataContent);
        this.udpSatEnabled_UIC = this.udpSendOnContent.addJCheckBox("UdpSendAfterTimeEnabled", (ActionListener)controlChangeAdapter);
        this.udpSatContent = new GridContentPanel(1);
        this.udpSatValue_UIC = this.udpSatContent.addJTextField(null, "UdpSendAfterTimeValueDesc", 100, (FocusListener)controlChangeAdapter);
        this.udpSatValue_UIC.setDocument(this.createIntegerDocument());
        this.udpSendOnContent.addSubPanel((JComponent)this.udpSatContent);
        this.udpSendOnContent.addTextLine("UdpSendAfterBytesEnabled");
        this.udpSabContent = new GridContentPanel(1);
        this.udpSabValue_UIC = this.udpSabContent.addJTextField(null, "UdpSendAfterBytesValueDesc", 100, (FocusListener)controlChangeAdapter);
        this.udpSabValue_UIC.setDocument(this.createIntegerDocument());
        this.udpSendOnContent.addSubPanel((JComponent)this.udpSabContent);
        this.udpClientContent.addSubPanel((JComponent)this.udpSendOnContent);
        this.udpClientContent.addTextLine("UdpSendToListDesc");
        this.udpSendToContent = new GridContentPanel(5);
        this.udpSendToContent.setBorder(BorderFactory.createLineBorder(Color.BLACK));
        this.udpSendToContent.addColumnHeading("Dest #", (ActionListener)controlChangeAdapter, 0, false);
        this.udpSendToContent.addColumnHeading("UdpSendToAddress", (ActionListener)controlChangeAdapter, 1, false);
        this.udpSendToContent.addColumnHeading("UdpSendToPort", (ActionListener)controlChangeAdapter, 2, false);
        this.udpSendToContent.addColumnHeading("UdpSendToDesc", (ActionListener)controlChangeAdapter, 3, false);
        this.udpSendToContent.addColumnHeading("UdpSendToEnabled", (ActionListener)controlChangeAdapter, 4, true);
        for (int i = 0; i < this.MAXDESTINATIONS; ++i) {
            JLabel jLabel = this.udpSendToContent.addJLabel(null, null, 30, 0, false);
            jLabel.setText("" + (i + 1));
            this.udpSendToAddress_UIC[i] = this.udpSendToContent.addJTextField(null, null, 100, (FocusListener)controlChangeAdapter, 1, false);
            this.udpSendToPort_UIC[i] = this.udpSendToContent.addJTextField(null, null, 100, (FocusListener)controlChangeAdapter, 2, false);
            this.udpSendToDesc_UIC[i] = this.udpSendToContent.addJTextField(null, null, 100, (FocusListener)controlChangeAdapter, 3, false);
            this.udpSendToEnabled_UIC[i] = this.udpSendToContent.addJCheckBox(null, (ActionListener)controlChangeAdapter, 4, true);
            this.udpSendToAddress_UIC[i].setDocument(this.createNetworkAddressDocument());
            this.udpSendToPort_UIC[i].setDocument(this.createIntegerDocument());
            this.udpSendToDesc_UIC[i].setDocument(this.createGeneralDocument());
        }
        JScrollPane jScrollPane = new JScrollPane((Component)this.udpSendToContent);
        jScrollPane.setOpaque(false);
        jScrollPane.getViewport().setOpaque(false);
        jScrollPane.setPreferredSize(new Dimension(300, 100));
        this.udpClientContent.addSubPanel((JComponent)jScrollPane);
        this.content.addSubPanel((JComponent)this.udpClientContent);
        this.content.addVGlue();
    }

    public String getName() {
        return "SerialPortServicesView";
    }

    public Component getViewContent() {
        return this.content;
    }

    public void setDevice(Device device) {
        super.setDevice(device);
        this.refreshViewKvpNode();
        this.refreshViewControls();
        device.addSettingChangeListener(this.settingChangeListener);
    }

    private void refreshViewKvpNode() {
        this.viewSettingTree.clear();
        this.tcpAutoConnectEnabledKvpField = this.viewSettingTree.mergeFrom(this.device.getInternalSettingTree(), "autoconnect", "state");
        this.tcpConnectTriggerKvpField = this.viewSettingTree.mergeFrom(this.device.getInternalSettingTree(), "autoconnect", "trigger");
        this.tcpConnectOnDataPatternKvpField = this.viewSettingTree.mergeFrom(this.device.getInternalSettingTree(), "autoconnect", "pattern");
        this.tcpConnectOnDataStripPatternKvpField = this.viewSettingTree.mergeFrom(this.device.getInternalSettingTree(), "autoconnect", "strip_pattern");
        this.tcpConnectToAddressKvpField = this.viewSettingTree.mergeFrom(this.device.getInternalSettingTree(), "autoconnect", "address");
        this.tcpConnectToProtocolKvpField = this.viewSettingTree.mergeFrom(this.device.getInternalSettingTree(), "autoconnect", "service");
        this.tcpConnectToPortKvpField = this.viewSettingTree.mergeFrom(this.device.getInternalSettingTree(), "autoconnect", "port");
        KvpNode kvpNode = this.viewSettingTree.mergeChild(this.device.getInternalSettingTree().getChild("udp_serial"), true);
        if (kvpNode != null) {
            this.udpClientEnabledKvpField = kvpNode.getChild("state");
            for (int i = 0; i < this.MAXDESTINATIONS; ++i) {
                KvpNode kvpNode2 = kvpNode.getChild("dest", i + 1);
                this.udpSendToEnabledKvpField[i] = kvpNode2.getChild("state");
                this.udpSendToAddressKvpField[i] = kvpNode2.getChild("address");
                this.udpSendToPortKvpField[i] = kvpNode2.getChild("port");
                this.udpSendToDescKvpField[i] = kvpNode2.getChild("desc");
            }
            this.udpSendOnDataEnabledKvpField = kvpNode.getChild("trigger_on_pattern");
            this.udpSendOnDataPatternKvpField = kvpNode.getChild("pattern");
            this.udpSendOnDataStripPatternKvpField = kvpNode.getChild("strip_pattern");
            this.udpSatEnabledKvpField = kvpNode.getChild("trigger_on_timeout");
            this.udpSatValueKvpField = kvpNode.getChild("timeout");
            this.udpSabValueKvpField = kvpNode.getChild("count");
        }
    }

    private void refreshViewControls() {
        if (this.tcpAutoConnectEnabledKvpField != null) {
            this.tcpAutoConnectEnabled_UIC.setSelected(RciProtocol.booleanValue((String)this.tcpAutoConnectEnabledKvpField.getStringValue()));
        }
        if (this.tcpConnectTriggerKvpField != null) {
            String string = this.tcpConnectTriggerKvpField.getStringValue();
            if (string.equals("always")) {
                this.tcpConnectOnAlways_UIC.setSelected(true);
            } else if (string.equals("data") || string.equals("string")) {
                this.tcpConnectOnData_UIC.setSelected(true);
            } else if (string.equals("dsr")) {
                this.tcpConnectOnDSR_UIC.setSelected(true);
            } else if (string.equals("dcd")) {
                this.tcpConnectOnDCD_UIC.setSelected(true);
            }
        }
        if (this.tcpConnectOnDataPatternKvpField != null) {
            this.tcpConnectOnDataPattern_UIC.setText(this.tcpConnectOnDataPatternKvpField.getStringValue());
        }
        if (this.tcpConnectOnDataStripPatternKvpField != null) {
            this.tcpConnectOnDataStripPattern_UIC.setSelected(RciProtocol.booleanValue((String)this.tcpConnectOnDataStripPatternKvpField.getStringValue()));
        }
        if (this.tcpConnectToAddressKvpField != null) {
            this.tcpConnectToAddress_UIC.setText(this.tcpConnectToAddressKvpField.getStringValue());
        }
        if (this.tcpConnectToProtocolKvpField != null) {
            this.tcpConnectToProtocol_UIC.setSelectedItem(this.tcpConnectToProtocolKvpField.getStringValue());
        }
        if (this.tcpConnectToPortKvpField != null) {
            this.tcpConnectToPort_UIC.setText(this.tcpConnectToPortKvpField.getStringValue());
        }
        if (this.udpClientEnabledKvpField != null) {
            this.udpClientEnabled_UIC.setSelected(RciProtocol.booleanValue((String)this.udpClientEnabledKvpField.getStringValue()));
        }
        for (int i = 0; i < this.MAXDESTINATIONS; ++i) {
            if (this.udpSendToEnabledKvpField[i] != null) {
                this.udpSendToEnabled_UIC[i].setSelected(RciProtocol.booleanValue((String)this.udpSendToEnabledKvpField[i].getStringValue()));
            }
            if (this.udpSendToAddressKvpField[i] != null) {
                this.udpSendToAddress_UIC[i].setText(this.udpSendToAddressKvpField[i].getStringValue());
            }
            if (this.udpSendToPortKvpField[i] != null) {
                this.udpSendToPort_UIC[i].setText(this.udpSendToPortKvpField[i].getStringValue());
            }
            if (this.udpSendToDescKvpField[i] == null) continue;
            this.udpSendToDesc_UIC[i].setText(this.udpSendToDescKvpField[i].getStringValue());
        }
        if (this.udpSendOnDataEnabledKvpField != null) {
            this.udpSendOnDataEnabled_UIC.setSelected(RciProtocol.booleanValue((String)this.udpSendOnDataEnabledKvpField.getStringValue()));
        }
        if (this.udpSendOnDataPatternKvpField != null) {
            this.udpSendOnDataPattern_UIC.setText(this.udpSendOnDataPatternKvpField.getStringValue());
        }
        if (this.udpSendOnDataStripPatternKvpField != null) {
            this.udpSendOnDataStripPattern_UIC.setSelected(RciProtocol.booleanValue((String)this.udpSendOnDataStripPatternKvpField.getStringValue()));
        }
        if (this.udpSatValueKvpField != null) {
            this.udpSatValue_UIC.setText(this.udpSatValueKvpField.getStringValue());
        }
        if (this.udpSatEnabledKvpField != null) {
            this.udpSatEnabled_UIC.setSelected(RciProtocol.booleanValue((String)this.udpSatEnabledKvpField.getStringValue()));
        }
        if (this.udpSabValueKvpField != null) {
            this.udpSabValue_UIC.setText(this.udpSabValueKvpField.getStringValue());
        }
        this.refreshViewControlStates();
    }

    private void refreshViewControlStates() {
        if (this.udpClientEnabledKvpField == null) {
            this.content.setContainerEnabled(false);
            return;
        }
        this.content.setContainerEnabled(true);
        this.tcpConnectOnAlways_UIC.setEnabled(this.tcpConnectTriggerKvpField != null);
        this.tcpConnectOnData_UIC.setEnabled(this.tcpConnectTriggerKvpField != null);
        this.tcpConnectOnDSR_UIC.setEnabled(this.tcpConnectTriggerKvpField != null);
        this.tcpConnectOnDCD_UIC.setEnabled(this.tcpConnectTriggerKvpField != null);
        this.tcpConnectOnDataPattern_UIC.setEnabled(this.tcpConnectOnDataPatternKvpField != null);
        this.tcpConnectOnDataStripPattern_UIC.setEnabled(this.tcpConnectOnDataStripPatternKvpField != null);
        this.tcpConnectToAddress_UIC.setEnabled(this.tcpConnectToAddressKvpField != null);
        this.tcpConnectToProtocol_UIC.setEnabled(this.tcpConnectToProtocolKvpField != null);
        this.tcpConnectToPort_UIC.setEnabled(this.tcpConnectToPortKvpField != null);
        if (this.tcpAutoConnectEnabledKvpField == null || !this.tcpAutoConnectEnabled_UIC.isSelected()) {
            this.tcpClientContent.setContainerEnabled(false);
        } else if (!this.tcpConnectOnData_UIC.isSelected()) {
            this.tcpConnectOnDataContent.setContainerEnabled(false);
        }
        this.udpClientEnabled_UIC.setEnabled(this.udpClientEnabledKvpField != null);
        this.udpSendOnDataEnabled_UIC.setEnabled(this.udpSendOnDataEnabledKvpField != null);
        this.udpSendOnDataPattern_UIC.setEnabled(this.udpSendOnDataPatternKvpField != null);
        this.udpSendOnDataStripPattern_UIC.setEnabled(this.udpSendOnDataStripPatternKvpField != null);
        this.udpSatValue_UIC.setEnabled(this.udpSatValueKvpField != null);
        this.udpSatEnabled_UIC.setEnabled(this.udpSatEnabledKvpField != null);
        this.udpSabValue_UIC.setEnabled(this.udpSabValueKvpField != null);
        for (int i = 0; i < this.MAXDESTINATIONS; ++i) {
            this.udpSendToEnabled_UIC[i].setEnabled(this.udpSendToEnabledKvpField[i] != null);
            this.udpSendToAddress_UIC[i].setEnabled(this.udpSendToAddressKvpField[i] != null);
            this.udpSendToPort_UIC[i].setEnabled(this.udpSendToPortKvpField[i] != null);
            this.udpSendToDesc_UIC[i].setEnabled(this.udpSendToDescKvpField[i] != null);
        }
        if (this.udpClientEnabledKvpField == null || !this.udpClientEnabled_UIC.isSelected()) {
            this.udpClientContent.setContainerEnabled(false);
        } else {
            if (this.udpSendOnDataEnabledKvpField == null || !this.udpSendOnDataEnabled_UIC.isSelected()) {
                this.udpSendOnDataContent.setContainerEnabled(false);
            }
            if (this.udpSatEnabledKvpField == null || !this.udpSatEnabled_UIC.isSelected()) {
                this.udpSatContent.setContainerEnabled(false);
            }
        }
    }

    public void activate() {
        SystemLog.debug((String)("Activating " + this.getName()));
    }

    public void deactivate() {
        SystemLog.debug((String)("Deactivating " + this.getName()));
    }

    public boolean isChanged() {
        return this.viewSettingTree.hasChanged();
    }

    public void validateChanges(Collection collection) {
        try {
            if (this.tcpAutoConnectEnabled_UIC.isSelected()) {
                // empty if block
            }
            if (this.udpClientEnabled_UIC.isSelected()) {
                if (!ValidationHelper.isValidRange((String)this.udpSabValue_UIC.getText(), (long)4L, (long)4096L)) {
                    collection.add(new ValidationError("SerialUdpSendAfterByteError"));
                }
                if (this.udpSatEnabled_UIC.isSelected() && !ValidationHelper.isValidRange((String)this.udpSatValue_UIC.getText(), (long)1L, (long)65535L)) {
                    collection.add(new ValidationError("SerialUdpSendAfterTimeError"));
                }
                for (int i = 0; i < this.MAXDESTINATIONS; ++i) {
                    if (!ValidationHelper.isValidIPAddress((String)this.udpSendToAddress_UIC[i].getText())) {
                        collection.add(new ValidationError("SerialUdpDestinationAddressError", new Serializable[]{String.valueOf(i + 1)}));
                    }
                    if (!ValidationHelper.isValidNetworkPort((String)this.udpSendToPort_UIC[i].getText())) {
                        collection.add(new ValidationError("SerialUdpDestinationPortError", new Serializable[]{String.valueOf(i + 1)}));
                    }
                    if (!this.udpSendToEnabled_UIC[i].isSelected()) continue;
                    if (InetAddress.getByName(this.udpSendToAddress_UIC[i].getText()).equals(InetAddress.getByName("0.0.0.0"))) {
                        collection.add(new ValidationError("SerialUdpDestinationAddressError", new Serializable[]{String.valueOf(i + 1)}));
                    }
                    if (Integer.parseInt(this.udpSendToPort_UIC[i].getText()) > 0) continue;
                    collection.add(new ValidationError("SerialUdpDestinationPortError", new Serializable[]{String.valueOf(i + 1)}));
                }
            }
        }
        catch (Exception exception) {
            System.out.println("Caught Exception in SerialPortServicesView::validationChanges()");
            exception.printStackTrace();
        }
    }

    public void getChanges(KvpNode kvpNode, KvpNode kvpNode2) {
        kvpNode.merge(this.viewSettingTree, false);
    }

    public void commitChanges() {
        this.viewSettingTree.resetChanged();
    }

    public void cancelChanges() {
        this.refreshViewKvpNode();
        this.refreshViewControls();
    }
}

