/*
 * Decompiled with CFR 0.152.
 */
package com.digi.config.ui;

import com.digi.config.core.Device;
import com.digi.config.core.DeviceChangeEvent;
import com.digi.config.core.DeviceChangeListener;
import com.digi.config.core.KvpField;
import com.digi.config.core.KvpNode;
import com.digi.config.core.RciProtocol;
import com.digi.config.core.ValidationError;
import com.digi.config.core.ValidationHelper;
import com.digi.config.ui.ConfigViewImpl;
import com.digi.config.ui.ControlChangeAdapter;
import com.digi.config.ui.GridContentPanel;
import com.digi.config.util.SystemLog;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.io.Serializable;
import java.net.InetAddress;
import java.util.Collection;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextField;

public class SerialUdpView
extends ConfigViewImpl {
    KvpNode viewSettingTree;
    DeviceChangeListener settingChangeListener;
    GridContentPanel content;
    GridContentPanel serverContent;
    GridContentPanel clientContent;
    GridContentPanel sendToContent;
    GridContentPanel socketIdContent;
    GridContentPanel sopContent;
    GridContentPanel sopCustomContent;
    GridContentPanel satContent;
    GridContentPanel sabContent;
    int MAXDESTINATIONS = 64;
    KvpField udpServerEnabledKvpField;
    KvpField udpServerPortKvpField;
    KvpField udpClientEnabledKvpField;
    KvpField[] udpSendToEnabledKvpField = new KvpField[this.MAXDESTINATIONS];
    KvpField[] udpSendToAddressKvpField = new KvpField[this.MAXDESTINATIONS];
    KvpField[] udpSendToPortKvpField = new KvpField[this.MAXDESTINATIONS];
    KvpField[] udpSendToDescKvpField = new KvpField[this.MAXDESTINATIONS];
    KvpField udpSocketIdEnabledKvpField;
    KvpField udpSocketIdKvpField;
    KvpField udpSopEnabledKvpField;
    KvpField udpSopPatternKvpField;
    KvpField udpSopStripPatternKvpField;
    KvpField udpSatEnabledKvpField;
    KvpField udpSatValueKvpField;
    KvpField udpSabEnabledKvpField;
    KvpField udpSabValueKvpField;
    JCheckBox udpServerEnabled_UIC;
    JTextField udpServerPort_UIC;
    JCheckBox udpClientEnabled_UIC;
    JCheckBox[] udpSendToEnabled_UIC = new JCheckBox[this.MAXDESTINATIONS];
    JTextField[] udpSendToAddress_UIC = new JTextField[this.MAXDESTINATIONS];
    JTextField[] udpSendToPort_UIC = new JTextField[this.MAXDESTINATIONS];
    JTextField[] udpSendToDesc_UIC = new JTextField[this.MAXDESTINATIONS];
    JCheckBox udpSocketIdEnabled_UIC;
    JTextField udpSocketId_UIC;
    JCheckBox udpSopEnabled_UIC;
    JRadioButton udpSopCR_UIC;
    JRadioButton udpSopCRLF_UIC;
    JRadioButton udpSopCustom_UIC;
    JTextField udpSopCustomString_UIC;
    JCheckBox udpSopStripPattern_UIC;
    JCheckBox udpSatEnabled_UIC;
    JTextField udpSatValue_UIC;
    JCheckBox udpSabEnabled_UIC;
    JTextField udpSabValue_UIC;

    public SerialUdpView() throws Exception {
        Serializable serializable;
        this.viewSettingTree = new KvpNode();
        this.settingChangeListener = new DeviceChangeListener(){

            public void deviceChanged(DeviceChangeEvent deviceChangeEvent) {
                SystemLog.debug((String)"SerialUdpView was notified that device kvpGroup changed");
                SerialUdpView.this.refreshViewKvpNode();
                SerialUdpView.this.refreshViewControls();
            }
        };
        this.content = new GridContentPanel(this.getName(), 1);
        ControlChangeAdapter controlChangeAdapter = new ControlChangeAdapter(){

            public void changePerformed(Object object, ActionEvent actionEvent, FocusEvent focusEvent) {
                block13: {
                    block22: {
                        block21: {
                            block20: {
                                block19: {
                                    block18: {
                                        block17: {
                                            block16: {
                                                block15: {
                                                    block14: {
                                                        block12: {
                                                            if (object != SerialUdpView.this.udpServerEnabled_UIC) break block12;
                                                            SerialUdpView.this.udpServerEnabledKvpField.setStringValue(RciProtocol.toString((boolean)SerialUdpView.this.udpServerEnabled_UIC.isSelected()));
                                                            break block13;
                                                        }
                                                        if (object != SerialUdpView.this.udpServerPort_UIC) break block14;
                                                        SerialUdpView.this.udpServerPortKvpField.setStringValue(SerialUdpView.this.udpServerPort_UIC.getText());
                                                        break block13;
                                                    }
                                                    if (object != SerialUdpView.this.udpClientEnabled_UIC) break block15;
                                                    SerialUdpView.this.udpClientEnabledKvpField.setStringValue(RciProtocol.toString((boolean)SerialUdpView.this.udpClientEnabled_UIC.isSelected()));
                                                    break block13;
                                                }
                                                if (object != SerialUdpView.this.udpSocketIdEnabled_UIC) break block16;
                                                SerialUdpView.this.udpSocketIdEnabledKvpField.setStringValue(RciProtocol.toString((boolean)SerialUdpView.this.udpSocketIdEnabled_UIC.isSelected()));
                                                break block13;
                                            }
                                            if (object != SerialUdpView.this.udpSocketId_UIC) break block17;
                                            SerialUdpView.this.udpSocketIdKvpField.setStringValue(SerialUdpView.this.udpSocketId_UIC.getText());
                                            break block13;
                                        }
                                        if (object != SerialUdpView.this.udpSopEnabled_UIC) break block18;
                                        SerialUdpView.this.udpSopEnabledKvpField.setStringValue(RciProtocol.toString((boolean)SerialUdpView.this.udpSopEnabled_UIC.isSelected()));
                                        break block13;
                                    }
                                    if (object != SerialUdpView.this.udpSopCR_UIC) break block19;
                                    if (!SerialUdpView.this.udpSopCR_UIC.isSelected()) break block13;
                                    SerialUdpView.this.udpSopPatternKvpField.setStringValue("CR");
                                    break block13;
                                }
                                if (object != SerialUdpView.this.udpSopCRLF_UIC) break block20;
                                if (!SerialUdpView.this.udpSopCRLF_UIC.isSelected()) break block13;
                                SerialUdpView.this.udpSopPatternKvpField.setStringValue("CR/LF");
                                break block13;
                            }
                            if (object != SerialUdpView.this.udpSopCustom_UIC) break block21;
                            if (!SerialUdpView.this.udpSopCustom_UIC.isSelected()) break block13;
                            SerialUdpView.this.udpSopPatternKvpField.setStringValue(SerialUdpView.this.udpSopCustomString_UIC.getText());
                            break block13;
                        }
                        if (object != SerialUdpView.this.udpSopCustomString_UIC) break block22;
                        if (!SerialUdpView.this.udpSopCustom_UIC.isSelected()) break block13;
                        SerialUdpView.this.udpSopPatternKvpField.setStringValue(SerialUdpView.this.udpSopCustomString_UIC.getText());
                        break block13;
                    }
                    if (object == SerialUdpView.this.udpSopStripPattern_UIC) {
                        SerialUdpView.this.udpSopStripPatternKvpField.setStringValue(RciProtocol.toString((boolean)SerialUdpView.this.udpSopStripPattern_UIC.isSelected()));
                    } else if (object == SerialUdpView.this.udpSatEnabled_UIC) {
                        SerialUdpView.this.udpSatEnabledKvpField.setStringValue(RciProtocol.toString((boolean)SerialUdpView.this.udpSatEnabled_UIC.isSelected()));
                    } else if (object == SerialUdpView.this.udpSatValue_UIC) {
                        SerialUdpView.this.udpSatValueKvpField.setStringValue(SerialUdpView.this.udpSatValue_UIC.getText());
                    } else if (object == SerialUdpView.this.udpSabValue_UIC) {
                        SerialUdpView.this.udpSabValueKvpField.setStringValue(SerialUdpView.this.udpSabValue_UIC.getText());
                    } else {
                        for (int i = 0; i < SerialUdpView.this.MAXDESTINATIONS; ++i) {
                            if (object == SerialUdpView.this.udpSendToEnabled_UIC[i]) {
                                SerialUdpView.this.udpSendToEnabledKvpField[i].setStringValue(RciProtocol.toString((boolean)SerialUdpView.this.udpSendToEnabled_UIC[i].isSelected()));
                                break;
                            }
                            if (object == SerialUdpView.this.udpSendToAddress_UIC[i]) {
                                SerialUdpView.this.udpSendToAddressKvpField[i].setStringValue(SerialUdpView.this.udpSendToAddress_UIC[i].getText());
                                break;
                            }
                            if (object == SerialUdpView.this.udpSendToPort_UIC[i]) {
                                SerialUdpView.this.udpSendToPortKvpField[i].setStringValue(SerialUdpView.this.udpSendToPort_UIC[i].getText());
                                break;
                            }
                            if (object != SerialUdpView.this.udpSendToDesc_UIC[i]) continue;
                            SerialUdpView.this.udpSendToDescKvpField[i].setStringValue(SerialUdpView.this.udpSendToDesc_UIC[i].getText());
                            break;
                        }
                    }
                }
                SerialUdpView.this.refreshViewControlStates();
            }
        };
        this.content.addHeadingBar("UdpServerHeading");
        this.udpServerEnabled_UIC = this.content.addJCheckBox("UdpServerEnabled", (ActionListener)controlChangeAdapter);
        this.serverContent = new GridContentPanel(1);
        this.serverContent.addTextLine("UdpServerDesc");
        this.udpServerPort_UIC = this.serverContent.addJTextField("UdpServerPort", "UdpServerPortDesc", 100, (FocusListener)controlChangeAdapter);
        this.udpServerPort_UIC.setDocument(this.createIntegerDocument());
        this.content.addSubPanel((JComponent)this.serverContent);
        this.content.addHeadingBar("UdpSerialHeading");
        this.udpSocketIdEnabled_UIC = this.content.addJCheckBox("UdpSocketIdEnabled", (ActionListener)controlChangeAdapter);
        this.socketIdContent = new GridContentPanel(1);
        this.udpSocketId_UIC = this.socketIdContent.addJTextField("UdpSocketId", "UdpSocketIdDesc", 100, (FocusListener)controlChangeAdapter);
        this.content.addSubPanel((JComponent)this.socketIdContent);
        this.content.addHeadingBar("UdpClientHeading");
        this.udpClientEnabled_UIC = this.content.addJCheckBox("UdpClientEnabled", (ActionListener)controlChangeAdapter);
        this.clientContent = new GridContentPanel(1);
        this.clientContent.addTextLine("UdpClientDesc");
        this.clientContent.addBlankLine();
        this.clientContent.addTextLine("UdpSendToDesc");
        this.sendToContent = new GridContentPanel(5);
        this.sendToContent.setBorder(BorderFactory.createLineBorder(Color.BLACK));
        this.sendToContent.addColumnHeading("Dest #", (ActionListener)controlChangeAdapter, 0, false);
        this.sendToContent.addColumnHeading("UdpSendToAddress", (ActionListener)controlChangeAdapter, 1, false);
        this.sendToContent.addColumnHeading("UdpSendToPort", (ActionListener)controlChangeAdapter, 2, false);
        this.sendToContent.addColumnHeading("UdpSendToDesc", (ActionListener)controlChangeAdapter, 3, false);
        this.sendToContent.addColumnHeading("UdpSendToEnabled", (ActionListener)controlChangeAdapter, 4, true);
        System.out.println("##### Generating Destinations:" + this.MAXDESTINATIONS);
        for (int i = 0; i < this.MAXDESTINATIONS; ++i) {
            serializable = this.sendToContent.addJLabel(null, null, 30, 0, false);
            ((JLabel)serializable).setText("" + (i + 1));
            this.udpSendToAddress_UIC[i] = this.sendToContent.addJTextField(null, null, 100, (FocusListener)controlChangeAdapter, 1, false);
            this.udpSendToPort_UIC[i] = this.sendToContent.addJTextField(null, null, 100, (FocusListener)controlChangeAdapter, 2, false);
            this.udpSendToDesc_UIC[i] = this.sendToContent.addJTextField(null, null, 100, (FocusListener)controlChangeAdapter, 3, false);
            this.udpSendToEnabled_UIC[i] = this.sendToContent.addJCheckBox(null, (ActionListener)controlChangeAdapter, 4, true);
            this.udpSendToAddress_UIC[i].setDocument(this.createNetworkAddressDocument());
            this.udpSendToPort_UIC[i].setDocument(this.createIntegerDocument());
            this.udpSendToDesc_UIC[i].setDocument(this.createGeneralDocument());
        }
        JScrollPane jScrollPane = new JScrollPane((Component)this.sendToContent);
        jScrollPane.setOpaque(false);
        jScrollPane.getViewport().setOpaque(false);
        jScrollPane.setPreferredSize(new Dimension(300, 100));
        this.clientContent.addSubPanel((JComponent)jScrollPane);
        this.clientContent.addTextLine("UdpSendTriggerDesc");
        this.udpSopEnabled_UIC = this.clientContent.addJCheckBox("UdpSendOnPatternEnabled", (ActionListener)controlChangeAdapter);
        this.sopContent = new GridContentPanel(1);
        this.udpSopCR_UIC = this.sopContent.addJRadioButton("UdpSendOnPatternCR", (ActionListener)controlChangeAdapter);
        this.udpSopCRLF_UIC = this.sopContent.addJRadioButton("UdpSendOnPatternCRLF", (ActionListener)controlChangeAdapter);
        this.udpSopCustom_UIC = this.sopContent.addJRadioButton("UdpSendOnPatternCustom", (ActionListener)controlChangeAdapter);
        serializable = new ButtonGroup();
        ((ButtonGroup)serializable).add(this.udpSopCR_UIC);
        ((ButtonGroup)serializable).add(this.udpSopCRLF_UIC);
        ((ButtonGroup)serializable).add(this.udpSopCustom_UIC);
        this.sopCustomContent = new GridContentPanel(2);
        this.udpSopCustomString_UIC = this.sopCustomContent.addJTextField(null, null, 100, (FocusListener)controlChangeAdapter, 1, false);
        this.udpSopCustomString_UIC.setDocument(this.createGeneralDocument());
        this.udpSopStripPattern_UIC = this.sopCustomContent.addJCheckBox("UdpSendOnPatternStripString", (ActionListener)controlChangeAdapter, 2, true);
        this.sopContent.addSubPanel((JComponent)this.sopCustomContent);
        this.clientContent.addSubPanel((JComponent)this.sopContent);
        this.udpSatEnabled_UIC = this.clientContent.addJCheckBox("UdpSendAfterTimeEnabled", (ActionListener)controlChangeAdapter);
        this.satContent = new GridContentPanel(1);
        this.udpSatValue_UIC = this.satContent.addJTextField(null, "UdpSendAfterTimeValueDesc", 100, (FocusListener)controlChangeAdapter);
        this.udpSatValue_UIC.setDocument(this.createIntegerDocument());
        this.clientContent.addSubPanel((JComponent)this.satContent);
        this.clientContent.addTextLine("UdpSendAfterBytesEnabled");
        this.sabContent = new GridContentPanel(1);
        this.udpSabValue_UIC = this.sabContent.addJTextField(null, "UdpSendAfterBytesValueDesc", 100, (FocusListener)controlChangeAdapter);
        this.udpSabValue_UIC.setDocument(this.createIntegerDocument());
        this.clientContent.addSubPanel((JComponent)this.sabContent);
        this.content.addSubPanel((JComponent)this.clientContent);
        this.content.addVGlue();
    }

    public String getName() {
        return "SerialUdpView";
    }

    public Component getViewContent() {
        return this.content;
    }

    public void setDevice(Device device) {
        super.setDevice(device);
        this.refreshViewKvpNode();
        this.refreshViewControls();
        device.addSettingChangeListener(this.settingChangeListener);
    }

    private void refreshViewKvpNode() {
        this.viewSettingTree.clear();
        KvpNode kvpNode = this.viewSettingTree.mergeChild(this.device.getInternalSettingTree().getChild("udp_server"), true);
        KvpNode kvpNode2 = this.viewSettingTree.mergeChild(this.device.getInternalSettingTree().getChild("udp_serial"), true);
        if (kvpNode != null) {
            this.udpServerEnabledKvpField = kvpNode.getChild("state");
            this.udpServerPortKvpField = kvpNode.getChild("port");
        }
        if (kvpNode2 != null) {
            this.udpSocketIdEnabledKvpField = kvpNode2.getChild("socketid_state");
            this.udpSocketIdKvpField = kvpNode2.getChild("socketid_string");
            this.udpClientEnabledKvpField = kvpNode2.getChild("state");
            for (int i = 0; i < this.MAXDESTINATIONS; ++i) {
                KvpNode kvpNode3 = kvpNode2.getChild("dest", i + 1);
                this.udpSendToEnabledKvpField[i] = kvpNode3.getChild("state");
                this.udpSendToAddressKvpField[i] = kvpNode3.getChild("address");
                this.udpSendToPortKvpField[i] = kvpNode3.getChild("port");
                this.udpSendToDescKvpField[i] = kvpNode3.getChild("desc");
            }
            this.udpSopEnabledKvpField = kvpNode2.getChild("trigger_on_pattern");
            this.udpSopPatternKvpField = kvpNode2.getChild("pattern");
            this.udpSopStripPatternKvpField = kvpNode2.getChild("strip_pattern");
            this.udpSatEnabledKvpField = kvpNode2.getChild("trigger_on_timeout");
            this.udpSatValueKvpField = kvpNode2.getChild("timeout");
            this.udpSabValueKvpField = kvpNode2.getChild("count");
        }
    }

    private void refreshViewControls() {
        if (this.udpServerEnabledKvpField == null) {
            this.content.setContainerEnabled(false);
            return;
        }
        if (this.udpServerEnabledKvpField != null) {
            this.udpServerEnabled_UIC.setSelected(RciProtocol.booleanValue((String)this.udpServerEnabledKvpField.getStringValue()));
        }
        if (this.udpServerPortKvpField != null) {
            this.udpServerPort_UIC.setText(this.udpServerPortKvpField.getStringValue());
        }
        if (this.udpClientEnabledKvpField != null) {
            this.udpClientEnabled_UIC.setSelected(RciProtocol.booleanValue((String)this.udpClientEnabledKvpField.getStringValue()));
        }
        for (int i = 0; i < this.MAXDESTINATIONS; ++i) {
            if (this.udpSendToEnabledKvpField[i] != null) {
                this.udpSendToEnabled_UIC[i].setSelected(RciProtocol.booleanValue((String)this.udpSendToEnabledKvpField[i].getStringValue()));
            }
            if (this.udpSendToAddressKvpField[i] != null) {
                this.udpSendToAddress_UIC[i].setText(this.udpSendToAddressKvpField[i].getStringValue());
            }
            if (this.udpSendToPortKvpField[i] != null) {
                this.udpSendToPort_UIC[i].setText(this.udpSendToPortKvpField[i].getStringValue());
            }
            if (this.udpSendToDescKvpField[i] == null) continue;
            this.udpSendToDesc_UIC[i].setText(this.udpSendToDescKvpField[i].getStringValue());
        }
        if (this.udpSocketIdEnabledKvpField != null) {
            this.udpSocketIdEnabled_UIC.setSelected(RciProtocol.booleanValue((String)this.udpSocketIdEnabledKvpField.getStringValue()));
        }
        if (this.udpSocketIdKvpField != null) {
            this.udpSocketId_UIC.setText(this.udpSocketIdKvpField.getStringValue());
        }
        if (this.udpSopEnabledKvpField != null) {
            this.udpSopEnabled_UIC.setSelected(RciProtocol.booleanValue((String)this.udpSopEnabledKvpField.getStringValue()));
        }
        if (this.udpSopPatternKvpField != null) {
            String string = this.udpSopPatternKvpField.getStringValue();
            if (string.equals("CR")) {
                this.udpSopCR_UIC.setSelected(true);
            } else if (string.equals("CR/LF")) {
                this.udpSopCRLF_UIC.setSelected(true);
            } else {
                this.udpSopCustom_UIC.setSelected(true);
                this.udpSopCustomString_UIC.setText(string);
            }
        }
        if (this.udpSatValueKvpField != null) {
            this.udpSatValue_UIC.setText(this.udpSatValueKvpField.getStringValue());
        }
        if (this.udpSatEnabledKvpField != null) {
            this.udpSatEnabled_UIC.setSelected(RciProtocol.booleanValue((String)this.udpSatEnabledKvpField.getStringValue()));
        }
        if (this.udpSabValueKvpField != null) {
            this.udpSabValue_UIC.setText(this.udpSabValueKvpField.getStringValue());
        }
        this.refreshViewControlStates();
    }

    private void refreshViewControlStates() {
        this.content.setContainerEnabled(true);
        this.udpServerEnabled_UIC.setEnabled(this.udpServerEnabledKvpField != null);
        this.udpServerPort_UIC.setEnabled(this.udpServerPortKvpField != null);
        this.udpClientEnabled_UIC.setEnabled(this.udpClientEnabledKvpField != null);
        this.udpSocketIdEnabled_UIC.setEnabled(this.udpSocketIdEnabledKvpField != null);
        this.udpSocketId_UIC.setEnabled(this.udpSocketIdKvpField != null);
        this.udpSopCR_UIC.setEnabled(this.udpSopPatternKvpField != null);
        this.udpSopCRLF_UIC.setEnabled(this.udpSopPatternKvpField != null);
        this.udpSopCustom_UIC.setEnabled(this.udpSopPatternKvpField != null);
        this.udpSopEnabled_UIC.setEnabled(this.udpSopEnabledKvpField != null);
        this.udpSatValue_UIC.setEnabled(this.udpSatValueKvpField != null);
        this.udpSatEnabled_UIC.setEnabled(this.udpSatEnabledKvpField != null);
        this.udpSabValue_UIC.setEnabled(this.udpSabValueKvpField != null);
        for (int i = 0; i < this.MAXDESTINATIONS; ++i) {
            this.udpSendToEnabled_UIC[i].setEnabled(this.udpSendToEnabledKvpField[i] != null);
            this.udpSendToAddress_UIC[i].setEnabled(this.udpSendToAddressKvpField[i] != null);
            this.udpSendToPort_UIC[i].setEnabled(this.udpSendToPortKvpField[i] != null);
            this.udpSendToDesc_UIC[i].setEnabled(this.udpSendToDescKvpField[i] != null);
        }
        if (this.udpServerEnabledKvpField == null || !this.udpServerEnabled_UIC.isSelected()) {
            this.serverContent.setContainerEnabled(false);
        }
        if (this.udpSocketIdEnabledKvpField == null || !this.udpSocketIdEnabled_UIC.isSelected()) {
            this.socketIdContent.setContainerEnabled(false);
        }
        if (this.udpClientEnabledKvpField == null || !this.udpClientEnabled_UIC.isSelected()) {
            this.clientContent.setContainerEnabled(false);
        } else {
            if (this.udpSopEnabledKvpField == null || !this.udpSopEnabled_UIC.isSelected()) {
                this.sopContent.setContainerEnabled(false);
            } else if (!this.udpSopCustom_UIC.isSelected()) {
                this.sopCustomContent.setContainerEnabled(false);
            }
            if (this.udpSatEnabledKvpField == null || !this.udpSatEnabled_UIC.isSelected()) {
                this.satContent.setContainerEnabled(false);
            }
        }
    }

    public void activate() {
        SystemLog.debug((String)("Activating " + this.getName()));
    }

    public void deactivate() {
        SystemLog.debug((String)("Deactivating " + this.getName()));
    }

    public boolean isChanged() {
        return this.viewSettingTree.hasChanged();
    }

    public void validateChanges(Collection collection) {
        try {
            if (this.udpServerEnabled_UIC.isSelected() && (!ValidationHelper.isValidNetworkPort((String)this.udpServerPort_UIC.getText()) || Integer.parseInt(this.udpServerPort_UIC.getText()) <= 0)) {
                collection.add(new ValidationError("SerialUdpServerPortError"));
            }
            if (this.udpClientEnabled_UIC.isSelected()) {
                if (this.udpSocketIdEnabled_UIC.isSelected() && (this.udpSocketId_UIC.getText().length() <= 0 || this.udpSocketId_UIC.getText().length() > 40)) {
                    collection.add(new ValidationError("SerialUdpSocketIdError"));
                }
                if (this.udpSopEnabled_UIC.isSelected() && !this.udpSopCR_UIC.isSelected() && !this.udpSopCRLF_UIC.isSelected()) {
                    if (this.udpSopCustom_UIC.isSelected()) {
                        if (this.udpSopCustomString_UIC.getText().length() == 0) {
                            collection.add(new ValidationError("SerialUdpCustomStringError"));
                        }
                    } else {
                        collection.add(new ValidationError("SerialUdpSendOnPatternError"));
                    }
                }
                if (!ValidationHelper.isValidRange((String)this.udpSabValue_UIC.getText(), (long)4L, (long)4096L)) {
                    collection.add(new ValidationError("SerialUdpSendAfterByteError"));
                }
                if (this.udpSatEnabled_UIC.isSelected() && !ValidationHelper.isValidRange((String)this.udpSatValue_UIC.getText(), (long)1L, (long)65535L)) {
                    collection.add(new ValidationError("SerialUdpSendAfterTimeError"));
                }
                for (int i = 0; i < this.MAXDESTINATIONS; ++i) {
                    if (!ValidationHelper.isValidIPAddress((String)this.udpSendToAddress_UIC[i].getText())) {
                        collection.add(new ValidationError("SerialUdpDestinationAddressError", new Serializable[]{String.valueOf(i + 1)}));
                    }
                    if (!ValidationHelper.isValidNetworkPort((String)this.udpSendToPort_UIC[i].getText())) {
                        collection.add(new ValidationError("SerialUdpDestinationPortError", new Serializable[]{String.valueOf(i + 1)}));
                    }
                    if (!this.udpSendToEnabled_UIC[i].isSelected()) continue;
                    if (InetAddress.getByName(this.udpSendToAddress_UIC[i].getText()).equals(InetAddress.getByName("0.0.0.0"))) {
                        collection.add(new ValidationError("SerialUdpDestinationAddressError", new Serializable[]{String.valueOf(i + 1)}));
                    }
                    if (Integer.parseInt(this.udpSendToPort_UIC[i].getText()) > 0) continue;
                    collection.add(new ValidationError("SerialUdpDestinationPortError", new Serializable[]{String.valueOf(i + 1)}));
                }
            }
        }
        catch (Exception exception) {
            System.out.println("Caught Exception in SerialUdpView::validationChanges()");
            exception.printStackTrace();
        }
    }

    public void getChanges(KvpNode kvpNode, KvpNode kvpNode2) {
        kvpNode.merge(this.viewSettingTree, false);
    }

    public void commitChanges() {
        this.viewSettingTree.resetChanged();
    }

    public void cancelChanges() {
        this.refreshViewKvpNode();
        this.refreshViewControls();
    }
}

