/*
 * Decompiled with CFR 0.152.
 */
package com.digi.config.core;

import com.digi.config.core.DeviceChangeEvent;
import com.digi.config.core.DeviceChangeListener;
import com.digi.config.core.DeviceChangeSupport;
import com.digi.config.core.DeviceCommandException;
import com.digi.config.core.DeviceValidationException;
import com.digi.config.core.KvpNode;
import com.digi.config.core.RciQuerySettingCommand;
import com.digi.config.core.RciQueryStateCommand;
import com.digi.config.core.RciRebootCommand;
import com.digi.config.core.RciServer;
import com.digi.config.core.RciSetFactoryDefaultCommand;
import com.digi.config.core.RciSetSettingCommand;
import com.digi.config.core.RciSetStateCommand;
import com.digi.config.ui.SplashScreenPanel;
import com.digi.config.util.SystemLog;
import java.net.MalformedURLException;

public class Device {
    private static Device defaultInstance = null;
    RciServer rciServer = new RciServer();
    KvpNode settingTree;
    KvpNode stateTree;
    protected transient DeviceChangeSupport settingKvpNodeListeners;
    protected transient DeviceChangeSupport stateKvpNodeListeners;

    public static Device getDefaultInstance() {
        return defaultInstance;
    }

    public static void setDefaultInstance(Device device) {
        defaultInstance = device;
    }

    public Device() throws MalformedURLException {
        SplashScreenPanel.currentScreen().updateProgress();
        this.settingTree = new KvpNode();
        this.stateTree = new KvpNode();
        SplashScreenPanel.currentScreen().updateProgress();
        this.settingKvpNodeListeners = new DeviceChangeSupport(this);
        this.stateKvpNodeListeners = new DeviceChangeSupport(this);
        SplashScreenPanel.currentScreen().updateProgress();
    }

    public void setUrlName(String string) throws MalformedURLException {
        this.rciServer.setName(string);
        this.settingTree.clear();
        this.stateTree.clear();
    }

    public String getUrlName() {
        return this.rciServer.getName();
    }

    public KvpNode getInternalSettingTree() {
        return this.settingTree;
    }

    public KvpNode getSettingTree() {
        return (KvpNode)this.settingTree.copy();
    }

    public void setSettingTree(KvpNode kvpNode) throws DeviceValidationException, DeviceCommandException {
        if (!kvpNode.hasChanged()) {
            SystemLog.debug("Device.setSettingsTree invoked but no changed fields were found - ignoring request.");
            return;
        }
        SystemLog.debug("Device.setSettingsTree invoked. Create RciSetSettingsCommand");
        RciSetSettingCommand rciSetSettingCommand = new RciSetSettingCommand(kvpNode);
        try {
            SystemLog.debug("send RciSetSettingsCommand");
            this.rciServer.sendCommand(rciSetSettingCommand);
            SystemLog.debug("get RciSetSettingsCommand results");
            KvpNode kvpNode2 = rciSetSettingCommand.getResults();
            if (rciSetSettingCommand.hasErrors()) {
                throw new DeviceCommandException(rciSetSettingCommand, null);
            }
            if (kvpNode2.hasErrors()) {
                throw new DeviceValidationException(kvpNode2);
            }
            this.settingTree.merge(kvpNode, false);
            if (this.settingTree.hasChanged()) {
                this.settingKvpNodeListeners.fireDeviceChange(new DeviceChangeEvent(this));
                this.settingTree.resetChanged();
            }
        }
        catch (DeviceValidationException deviceValidationException) {
            throw deviceValidationException;
        }
        catch (Exception exception) {
            SystemLog.debug("Error updating device settings through RCI server", exception);
            throw new DeviceCommandException(rciSetSettingCommand, exception);
        }
    }

    public void refreshSettingTree() throws DeviceCommandException {
        SplashScreenPanel.currentScreen().updateProgress();
        SystemLog.debug("Device.refreshSettingTree invoked. Create QuerySettingCommand");
        KvpNode kvpNode = new KvpNode();
        SplashScreenPanel.currentScreen().updateProgress();
        RciQuerySettingCommand rciQuerySettingCommand = new RciQuerySettingCommand(kvpNode);
        SplashScreenPanel.currentScreen().updateProgress();
        try {
            SystemLog.debug("send RciQuerySettingCommand");
            this.rciServer.sendCommand(rciQuerySettingCommand);
            SplashScreenPanel.currentScreen().updateProgress();
            SystemLog.debug("get RciQuerySettingCommand results");
            if (rciQuerySettingCommand.hasErrors()) {
                throw new DeviceCommandException(rciQuerySettingCommand, null);
            }
            KvpNode kvpNode2 = rciQuerySettingCommand.getResults();
            SplashScreenPanel.currentScreen().updateProgress();
            boolean bl = this.settingTree.getAllGroups().size() == 0 || kvpNode2.getAllGroups().size() == 0;
            this.settingTree.merge(kvpNode2);
            SplashScreenPanel.currentScreen().updateProgress();
            if (bl || this.settingTree.hasChanged()) {
                this.settingKvpNodeListeners.fireDeviceChange(new DeviceChangeEvent(this));
                this.settingTree.resetChanged();
            }
        }
        catch (Exception exception) {
            SystemLog.debug("Error getting device setting from RCI server", exception);
            throw new DeviceCommandException(rciQuerySettingCommand, exception);
        }
    }

    public KvpNode getInternalStateTree() {
        return this.stateTree;
    }

    public void setStateTree(KvpNode kvpNode) throws DeviceValidationException, DeviceCommandException {
        if (!kvpNode.hasChanged()) {
            SystemLog.debug("Device.setStateTree invoked but no changed fields were found - ignoring request.");
            return;
        }
        SystemLog.debug("Device.setStateTree invoked. Create RciSetStateCommand");
        RciSetStateCommand rciSetStateCommand = new RciSetStateCommand(kvpNode);
        try {
            SystemLog.debug("send RciSetStateCommand");
            this.rciServer.sendCommand(rciSetStateCommand);
            SystemLog.debug("get RciSetStateCommand results");
            KvpNode kvpNode2 = rciSetStateCommand.getResults();
            if (rciSetStateCommand.hasErrors()) {
                throw new DeviceCommandException(rciSetStateCommand, null);
            }
            if (kvpNode2.hasErrors()) {
                throw new DeviceValidationException(kvpNode2);
            }
            this.stateTree.merge(kvpNode, false);
            if (this.stateTree.hasChanged()) {
                this.stateKvpNodeListeners.fireDeviceChange(new DeviceChangeEvent(this));
                this.stateTree.resetChanged();
            }
        }
        catch (DeviceValidationException deviceValidationException) {
            throw deviceValidationException;
        }
        catch (Exception exception) {
            SystemLog.debug("Error updating device state data through RCI server", exception);
            throw new DeviceCommandException(rciSetStateCommand, exception);
        }
    }

    public void refreshStateTree() throws DeviceCommandException {
        try {
            this.refreshStateTree(new KvpNode());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void refreshStateTree(KvpNode kvpNode) throws DeviceCommandException {
        SystemLog.debug("Device.refreshStateTree invoked. Create RciQueryStateCommand");
        RciQueryStateCommand rciQueryStateCommand = new RciQueryStateCommand(kvpNode);
        SplashScreenPanel.currentScreen().updateProgress();
        try {
            SystemLog.debug("send RciQueryStateCommand");
            this.rciServer.sendCommand(rciQueryStateCommand);
            SplashScreenPanel.currentScreen().updateProgress();
            SystemLog.debug("get RciQueryStateCommand results");
            if (rciQueryStateCommand.hasErrors()) {
                throw new DeviceCommandException(rciQueryStateCommand, null);
            }
            KvpNode kvpNode2 = rciQueryStateCommand.getResults();
            SplashScreenPanel.currentScreen().updateProgress();
            boolean bl = this.stateTree.getAllGroups().size() == 0 || kvpNode2.getAllGroups().size() == 0;
            this.stateTree.merge(kvpNode2);
            if (bl || this.stateTree.hasChanged()) {
                this.stateKvpNodeListeners.fireDeviceChange(new DeviceChangeEvent(this));
                this.stateTree.resetChanged();
            }
        }
        catch (Exception exception) {
            SystemLog.debug("Error getting device state from RCI server", exception);
            throw new DeviceCommandException(rciQueryStateCommand, exception);
        }
    }

    public void reboot() throws DeviceCommandException {
        RciRebootCommand rciRebootCommand = new RciRebootCommand();
        try {
            SystemLog.debug("send RciRebootCommand");
            this.rciServer.sendCommand(rciRebootCommand);
            SystemLog.debug("get RciRebootCommand results");
            if (rciRebootCommand.hasErrors()) {
                throw new DeviceCommandException(rciRebootCommand, null);
            }
        }
        catch (Exception exception) {
            SystemLog.debug("Error sending reboot command to RCI server", exception);
            throw new DeviceCommandException(rciRebootCommand, exception);
        }
    }

    public void restoreFactoryDefaults() throws DeviceValidationException, DeviceCommandException {
        SystemLog.debug("Device.restoreFactoryDefaults invoked. Create RciSetFactoryDefaultCommand");
        KvpNode kvpNode = new KvpNode();
        RciSetFactoryDefaultCommand rciSetFactoryDefaultCommand = new RciSetFactoryDefaultCommand(kvpNode);
        try {
            SystemLog.debug("send RciSetFactoryDefaultCommand");
            this.rciServer.sendCommand(rciSetFactoryDefaultCommand);
            SystemLog.debug("get RciSetFactoryDefaultCommand results");
            KvpNode kvpNode2 = rciSetFactoryDefaultCommand.getResults();
            if (rciSetFactoryDefaultCommand.hasErrors()) {
                throw new DeviceCommandException(rciSetFactoryDefaultCommand, null);
            }
            if (kvpNode2.hasErrors()) {
                throw new DeviceValidationException(kvpNode2);
            }
        }
        catch (DeviceValidationException deviceValidationException) {
            throw deviceValidationException;
        }
        catch (Exception exception) {
            SystemLog.debug("Error restoring factory default device settings through RCI server", exception);
            throw new DeviceCommandException(rciSetFactoryDefaultCommand, exception);
        }
    }

    public void restoreBackupSettingTree(KvpNode kvpNode, String string) throws DeviceValidationException, DeviceCommandException {
        if (string == null) {
            string = "1.0";
        }
        SystemLog.debug("Device.restoreBackupSettingsTree invoked. Version=" + string);
        if (string.equals("1.1")) {
            kvpNode.setChanged();
            KvpNode kvpNode2 = this.getSettingTree();
            kvpNode2.mergeChildrenFrom(kvpNode, true);
            this.setSettingTree(kvpNode2);
        } else {
            RciSetSettingCommand rciSetSettingCommand = new RciSetSettingCommand(kvpNode);
            rciSetSettingCommand.setProtocolVersion(string);
            rciSetSettingCommand.setSendOnlyModified(false);
            try {
                SystemLog.debug("send RciSetSettingsCommand");
                this.rciServer.sendCommand(rciSetSettingCommand);
                SystemLog.debug("get RciSetSettingsCommand results");
                KvpNode kvpNode3 = rciSetSettingCommand.getResults();
                if (rciSetSettingCommand.hasErrors()) {
                    throw new DeviceCommandException(rciSetSettingCommand, null);
                }
                if (kvpNode3.hasErrors()) {
                    throw new DeviceValidationException(kvpNode3);
                }
            }
            catch (DeviceValidationException deviceValidationException) {
                throw deviceValidationException;
            }
            catch (Exception exception) {
                SystemLog.debug("Error updating device settings through RCI server", exception);
                throw new DeviceCommandException(rciSetSettingCommand, exception);
            }
            this.refreshSettingTree();
        }
    }

    public void addSettingChangeListener(DeviceChangeListener deviceChangeListener) {
        this.settingKvpNodeListeners.addListener(deviceChangeListener);
    }

    public void removeSettingChangeListener(DeviceChangeListener deviceChangeListener) {
        this.settingKvpNodeListeners.removeListener(deviceChangeListener);
    }

    public void addStateChangeListener(DeviceChangeListener deviceChangeListener) {
        this.stateKvpNodeListeners.addListener(deviceChangeListener);
    }

    public void removeStateChangeListener(DeviceChangeListener deviceChangeListener) {
        this.stateKvpNodeListeners.removeListener(deviceChangeListener);
    }
}

