/*
 * Decompiled with CFR 0.152.
 */
package com.digi.config.core;

import com.digi.config.core.RciAuthenticator;
import com.digi.config.core.RciCommand;
import com.digi.config.core.RciConnection;
import com.digi.config.ui.SplashScreenPanel;
import com.digi.config.util.SystemLog;
import java.io.DataOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Authenticator;
import java.net.URL;
import java.net.URLConnection;

public class RciHttpConnection
implements RciConnection {
    URL rciUrl;
    URLConnection connection;

    public RciHttpConnection(URL uRL) {
        SplashScreenPanel.currentScreen().updateProgress();
        this.rciUrl = uRL;
    }

    public void sendCommand(RciCommand rciCommand) throws Exception {
        try {
            Authenticator.setDefault(RciAuthenticator.getInstance());
            SplashScreenPanel.currentScreen().updateProgress();
            SystemLog.debug("Connecting to RCI Server at: " + this.rciUrl);
            this.connection = this.rciUrl.openConnection();
            SplashScreenPanel.currentScreen().updateProgress();
            this.connection.setDoOutput(true);
            this.connection.setUseCaches(false);
            this.connection.setRequestProperty("content-type", "application/x-www-form-urlencoded");
            OutputStream outputStream = this.connection.getOutputStream();
            DataOutputStream dataOutputStream = new DataOutputStream(outputStream);
            rciCommand.writeToStream(dataOutputStream);
            SplashScreenPanel.currentScreen().updateProgress();
            dataOutputStream.flush();
            dataOutputStream.close();
            outputStream.close();
            InputStream inputStream = this.connection.getInputStream();
            rciCommand.readResult(inputStream);
            inputStream.close();
            SplashScreenPanel.currentScreen().updateProgress();
        }
        catch (Exception exception) {
            SystemLog.debug("Error sending RciCommand through HttpRciConnection.", exception);
            throw exception;
        }
    }
}

