/*
 * Decompiled with CFR 0.152.
 */
package com.digi.config.core;

import com.digi.config.core.KvpNode;
import com.digi.config.core.RciAbstractCommand;
import com.digi.config.util.SystemLog;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Collection;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class RciSetSettingCommand
extends RciAbstractCommand {
    KvpNode settingTree;
    Collection errorList;
    boolean sendOnlyModified = true;
    String protocolVersion = "1.1";

    public RciSetSettingCommand(KvpNode kvpNode) {
        super("set_setting");
        this.settingTree = kvpNode;
    }

    public void setSendOnlyModified(boolean bl) {
        this.sendOnlyModified = bl;
    }

    public void setProtocolVersion(String string) {
        this.protocolVersion = string;
    }

    public void writeToStream(DataOutputStream dataOutputStream) throws IOException {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("<rci_request version=\"" + this.protocolVersion + "\">\n");
        stringBuffer.append("  <set_setting>\n");
        this.settingTree.childrenToXml(stringBuffer, "    ", this.sendOnlyModified);
        stringBuffer.append("  </set_setting>\n");
        stringBuffer.append("</rci_request>\n");
        System.out.println("Writing command to URL:");
        System.out.println(stringBuffer.toString());
        dataOutputStream.writeBytes(stringBuffer.toString());
    }

    public KvpNode getResults() throws Exception {
        if (this.resultDocument == null) {
            return null;
        }
        Node node = this.resultDocument.getFirstChild();
        String string = node.getNodeName();
        if (!string.equals("rci_reply")) {
            SystemLog.debug("Unexpected reply to RCI command. Reply string = " + string);
            throw new Exception("Unexpected RCI reply");
        }
        SystemLog.debug("Got rci_reply command");
        NodeList nodeList = node.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node2 = nodeList.item(i);
            if (node2.getNodeType() != 1) continue;
            node = node2;
            string = node.getNodeName();
            break;
        }
        if (!string.equals("set_setting")) {
            SystemLog.debug("Unexpected reply to RCI set_setting command. Reply string = " + string);
            throw new Exception("Unexpected RCI set_setting reply");
        }
        SystemLog.debug("Got set_setting response");
        KvpNode kvpNode = new KvpNode(node);
        return kvpNode;
    }

    public void dump(StringBuffer stringBuffer, String string) {
        stringBuffer.append("\n");
        stringBuffer.append(string + "RCI set_setting command\n");
        stringBuffer.append(string + "  Selection Criteria:\n");
        this.settingTree.dump(stringBuffer, string + "    ");
        stringBuffer.append(string + "  Result DOM Data: \n");
        RciSetSettingCommand.dumpTree(this.resultDocument, stringBuffer, string + "    ");
        stringBuffer.append("\n");
    }
}

