/*
 * Decompiled with CFR 0.152.
 */
package com.digi.config.core;

public class ValidationHelper {
    public static boolean isValidNetworkAddress(String string) {
        if (string == null || string.length() < 7 || string.length() > 15) {
            return false;
        }
        if (!string.matches("^\\d{1,3}\\.\\d{1,3}\\.\\d{1,3}\\.\\d{1,3}$")) {
            return false;
        }
        String[] stringArray = string.split("[.]");
        return Integer.parseInt(stringArray[0]) <= 255 && Integer.parseInt(stringArray[1]) <= 255 && Integer.parseInt(stringArray[2]) <= 255 && Integer.parseInt(stringArray[3]) <= 255;
    }

    public static boolean isValidNetworkPort(String string) {
        return ValidationHelper.isValidUnsigned16(string);
    }

    public static boolean isValidIPAddress(String string) {
        if (string == null) {
            return false;
        }
        if (!ValidationHelper.isValidNetworkAddress(string)) {
            return false;
        }
        String[] stringArray = string.split("[.]");
        return Integer.parseInt(stringArray[0]) != 255 || Integer.parseInt(stringArray[1]) != 255 || Integer.parseInt(stringArray[2]) != 255 || Integer.parseInt(stringArray[3]) != 255;
    }

    public static boolean isValidEmailAddress(String string) {
        if (string == null) {
            return false;
        }
        return string.matches("^[a-zA-Z0-9._-]+@[a-zA-Z0-9._-]+$");
    }

    public static boolean isValidInteger(String string) {
        if (string == null || string.length() == 0) {
            return false;
        }
        return string.matches("^[+-]{0,1}\\d+$");
    }

    public static boolean isValidRange(String string, long l, long l2) {
        if (string == null || l > l2) {
            return false;
        }
        if (!ValidationHelper.isValidInteger(string)) {
            return false;
        }
        try {
            long l3 = Long.parseLong(string);
            if (l3 < l || l3 > l2) {
                return false;
            }
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
        return true;
    }

    public static boolean isValidSigned32(String string) {
        return ValidationHelper.isValidRange(string, Integer.MIN_VALUE, Integer.MAX_VALUE);
    }

    public static boolean isValidUnsigned32(String string) {
        return ValidationHelper.isValidRange(string, 0L, Integer.MAX_VALUE);
    }

    public static boolean isValidSigned16(String string) {
        return ValidationHelper.isValidRange(string, -32768L, 32767L);
    }

    public static boolean isValidUnsigned16(String string) {
        return ValidationHelper.isValidRange(string, 0L, 65535L);
    }

    public static boolean isValidSigned8(String string) {
        return ValidationHelper.isValidRange(string, -128L, 127L);
    }

    public static boolean isValidUnsigned8(String string) {
        return ValidationHelper.isValidRange(string, 0L, 255L);
    }
}

