/*
 * Decompiled with CFR 0.152.
 */
package com.digi.config.util;

import com.digi.config.core.ControllerImpl;
import com.digi.config.util.ConfigSettings;
import com.digi.config.util.SystemLogCtlr;
import com.digi.config.util.SystemLogEntry;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.Date;

public class SystemLogCtlrImpl
extends ControllerImpl
implements SystemLogCtlr {
    private boolean logToFile = new Boolean(ConfigSettings.getProperty("LogSettings", "LogToFile"));
    private String logFileName;
    private boolean logDebugMsg;
    private PrintWriter printWriter;

    SystemLogCtlrImpl(String string) {
        try {
            this.logFileName = ConfigSettings.getProperty("LogSettings", string);
        }
        catch (Exception exception) {
            String string2 = "";
            string2 = string.substring(0, string.lastIndexOf("LogFileName"));
            this.logFileName = string2 + "log.txt";
        }
        this.logDebugMsg = new Boolean(ConfigSettings.getProperty("LogSettings", "LogDebugMsg"));
        this.logDebugMsg = true;
    }

    public void add(SystemLogEntry systemLogEntry) throws Exception {
        SystemLogEntry systemLogEntry2 = systemLogEntry;
        if (!this.logDebugMsg && systemLogEntry2.getSeverity() == 0) {
            return;
        }
        super.add(systemLogEntry);
        PrintWriter printWriter = this.getPrintWriter();
        if (printWriter != null) {
            SystemLogEntry.ExceptionInfo exceptionInfo;
            printWriter.println(new Date() + "::" + systemLogEntry2.getServiceId() + " - " + systemLogEntry2.getMsg());
            printWriter.println();
            if (systemLogEntry2.hasDetailedMsg()) {
                printWriter.println("          " + systemLogEntry2.getDetailedMsg());
            }
            if ((exceptionInfo = systemLogEntry2.getExceptionInfo()) != null) {
                printWriter.println("          " + exceptionInfo.name);
                printWriter.println("          " + exceptionInfo.message);
                printWriter.println("          " + exceptionInfo.callStack);
            }
        }
    }

    public boolean isDebugLoggingEnabled() {
        return this.logDebugMsg;
    }

    private PrintWriter getPrintWriter() {
        if (!this.logToFile) {
            return null;
        }
        if (this.printWriter == null) {
            try {
                String string = System.getProperty("user.home") + File.separatorChar + "logs";
                System.out.println("Logging to dir: " + string);
                File file = new File(string);
                file.mkdir();
                File file2 = new File(file, this.logFileName);
                if (file2.exists()) {
                    file2.delete();
                }
                file2.createNewFile();
                this.printWriter = new PrintWriter((Writer)new FileWriter(string + File.separator + this.logFileName, true), true);
            }
            catch (IOException iOException) {
                this.printWriter = new PrintWriter(System.out);
                this.printWriter.println("Unable to open log file '" + this.logFileName + "'. Sending log data to console instead");
            }
        }
        return this.printWriter;
    }
}

